#ifndef BLAST_INPUT_DIRECTX8_JOYSTICKDX8_H
#define BLAST_INPUT_DIRECTX8_JOYSTICKDX8_H

#include "Blast/Input/IJoystick.h"


namespace Blast
{
	namespace Input
	{
		/// WCXeBbN̗p̓̓foCX
		class JoystickDeviceDX8;

		/// MEMO:̃WCXeBbNɂ͂ǂ΂悢ł傤H
		/// WCXeBbN̕ێ@R[obN\bhȂ̂ŁA
		/// @lKv܂B

		/// DirectX8InputDeviceWCXeBbNƂčsNX
		class JoystickDX8 : public Blast::Input::IJoystick
		{
		public:
			//====================================================================================================
			// Static
			//----------------------------------------------------------------------------------------------------

			/// MEMOT:DIJOYSTATE2Œ`Ă鐔ƓlłB
			/// {^̐
			static const int mStKButtonCount = 128;

			/// MEMOT:DIJOYSTATE2Œ`Ă鐔ƓlłB
			/// nbg̐
			static const int mStKPOVCount = 4;


			//====================================================================================================
			// Enumerate
			//----------------------------------------------------------------------------------------------------

			/// XeBbN̗񋓑
			enum EStick
			{
				/// 
				eSTICK_LEFT,

				/// E
				eSTICK_RIGHT,

				/// 񋓍ڂ̐
				eSTICK_COUNT,
			};

			/// Ԃ̎
			enum EState
			{
				/// O
				eSTATE_OLD,

				/// 
				eSTATE_CURRENT,

				/// 񋓗vf̐
				eSTATE_COUNT,
			};


			//====================================================================================================
			// Struct
			//----------------------------------------------------------------------------------------------------

			/// WCXeBbN̓͂̏
			struct SJoystickInputState
			{
			public:
				/// Ăꍇ̍XV
				void UpdateDown(const float&);

				/// Ăꍇ̍XV
				void UpdateUp(const float&);

				/// Ă鎞
				float mElapsedTimeDown;

				/// Ăx͎
				float mElapsedTimeDelayDown;

				/// Ă鎞
				float mElapsedTimeUp;

				/// Ăx͎
				float mElapsedTimeDelayUp;

			private:
			};


			//====================================================================================================
			// Operation
			//----------------------------------------------------------------------------------------------------

			/// RXgN^
			JoystickDX8();

			/// fXgN^
			~JoystickDX8();

			/// foCX쐬
			virtual bool Create(HWND, LPDIRECTINPUT8);

			/// XV
			virtual void Update(const float& kRDelta);

			/// XeBbNX̌X|ʂ擾
			virtual int GetStickTiltX(Sticks::EStick) const;

			/// XeBbNY̌X|ʂ擾
			virtual int GetStickTiltY(Sticks::EStick) const;

			/// XeBbŃ{X̌X|ʂlĂ邩
			virtual bool IsStickTiltPlusX(Sticks::EStick, int tiltBorder) const;

			/// XeBbŃ|X̌X|ʂlĂ邩
			virtual bool IsStickTiltMinusX(Sticks::EStick, int tiltBorder) const;

			/// XeBbŃ{Y̌X|ʂlĂ邩
			virtual bool IsStickTiltPlusY(Sticks::EStick, int tiltBorder) const;

			/// XeBbŃ|Y̌X|ʂlĂ邩
			virtual bool IsStickTiltMinusY(Sticks::EStick, int tiltBorder) const;

			/// {^Ă邩擾
			virtual bool IsDown(Buttons::EButton) const;

			/// {^ꂽuԂ擾
			virtual bool IsJustDown(Buttons::EButton) const;

			/// {^Ă邩擾
			virtual bool IsUp(Buttons::EButton) const;

			/// {^ꂽuԂ擾
			virtual bool IsJustUp(Buttons::EButton) const;

			/// {^Ă邩ԊuŎ擾
			virtual bool IsRapidDown(Buttons::EButton, const float& kRInterval);

			/// {^Ă邩ԊuŎ擾
			virtual bool IsRapidUp(Buttons::EButton, const float& kRInterval);

			/// {^Ă邩莞ԌォԊuŎ擾
			virtual bool IsDelayRapidDown(Buttons::EButton, const float& kRInterval, const float& kRDelay);

			/// {^Ă邩莞ԌォԊuŎ擾
			virtual bool IsDelayRapidUp(Buttons::EButton, const float& kRInterval, const float& kRDelay);

			/// \L[Ă邩擾
			virtual bool IsDownPOV(PointOfViews::EPointOfView, int index = 0) const;

			/// \L[Ă邩擾
			virtual bool IsUpPOV(PointOfViews::EPointOfView, int index = 0) const;

			/// \L[ꂽuԂ擾
			virtual bool IsJustDownPOV(PointOfViews::EPointOfView, int index = 0) const;

			/// \L[ꂽuԂ擾
			virtual bool IsJustUpPOV(PointOfViews::EPointOfView, int index = 0) const;

			/// \L[Ă邩ԊuŎ擾
			virtual bool IsRapidDownPOV(PointOfViews::EPointOfView, float interval, int index = 0);

			/// \L[Ă邩ԊuŎ擾
			virtual bool IsRapidUpPOV(PointOfViews::EPointOfView, float interval, int index = 0);

			/// \L[Ă邩莞ԌォԊuŎ擾
			virtual bool IsDelayRapidDownPOV(PointOfViews::EPointOfView, float interval, float delay, int index = 0);

			/// \L[Ă邩莞ԌォԊuŎ擾
			virtual bool IsDelayRapidUpPOV(PointOfViews::EPointOfView, float interval, float delay, int index = 0);

		private:
			/// WCXeBbNfoCX
			JoystickDeviceDX8* mPDevice;

			/// e͂̏
			DIJOYSTATE2 mJoystickStatus[eSTATE_COUNT];

			/// {^̏
			SJoystickInputState mButtonStatus[mStKButtonCount];

			/// nbg̏
			SJoystickInputState mPOVStatus[mStKPOVCount][PointOfViews::ePOV_COUNT];


			//====================================================================================================
			// PrivateOperation
			//----------------------------------------------------------------------------------------------------

			/// WCXeBbNł邩ǂ
			bool IsExistJoystick() const;

			/// WCXeBbNȂǂ
			bool IsNothingJoystick() const;

			/// XeBbNX̌X|ʂ擾
			const LONG& GetStickTiltXByIndex(const int& stickIndex) const;

			/// XeBbNY̌X|ʂ擾
			const LONG& GetStickTiltYByIndex(const int& stickIndex) const;

			/// XeBbŇX|ʂ{̈lȏォǂ
			bool IsStickTiltOver(const LONG& kRTilt, const LONG& kRBorder) const;

			/// XeBbŇX|ʂ|̈lȉǂ
			bool IsStickTiltUnder(const LONG& kRTilt, const LONG& kRBorder) const;

			/// {^̏ԂLǂ
			bool IsEnableButton(const u8&) const;

			/// {^̏Ԃǂ
			bool IsDisableButton(const u8&) const;

			/// nbg̏ԂLǂ
			bool IsEnablePOV(const DWORD&, const int&) const;

			/// nbg̏Ԃǂ
			bool IsDisablePOV(const DWORD&, const int&) const;

			/// WCXeBbNXV
			void UpdateJoystick(const float&);
		};

	} // namespace Input
} // namespace Blast

#endif // BLAST_INPUT_DIRECTX8_JOYSTICKDX8_H