#ifndef BLAST_IO_FILE_H
#define BLAST_IO_FILE_H

namespace Blast
{
	namespace IO
	{
		/// t@C쏈SNX
		class File
		{
		public:
			//====================================================================================================
			// Operation
			//----------------------------------------------------------------------------------------------------

			/// RXgN^
			File();

			/// fXgN^
			virtual ~File();


			/// t@CWJ
			bool Open(const TCHAR* kPFullPath, const TCHAR* kPMode = _T("rt, ccs=UTF-8"));

			/// t@C
			void Close();


			/// V[Nʒu擾
			long GetSeekPosition();

			/// V[NʒuύX
			void Seek(int);

			/// V[Nʒu擪ɐݒ
			void SeekStart();

			/// V[NʒuŌɐݒ
			void SeekEnd();

			/// EOFǂ擾
			bool IsEOF();


			/// ǂݍ
			void Read(TCHAR pOut[], int streamSize = 1024);

			/// sǂݍ
			void ReadLine(TCHAR pOut[], int streamSize = 1024);

			/// tH[}bgwɉēǂݍ
			void ReadFormat(const TCHAR* kPFormat, void* pOut, const int* pStringCount = NULL);


			/// 
			void Write(const TCHAR*);

			/// s
			void WriteLine(const TCHAR*);

			/// tH[}bgwɉď
			template <class T>
			void WriteFormat(const TCHAR* kPFormat, const T* kPIn)
			{
				// ASSERT:ȃ|C^Ȃ玀
				ASSERT_PF(kPIn, _T("|C^łB"));
				
				_ftprintf(mPFile, kPFormat, *kPIn);
			}


			/// t@CIuWFNg擾
			const FILE* GetFileObject() const;

			/// t@CIuWFNg擾
			FILE* GetFileObject();


			/// pX擾
			const tstring& GetFullPathRef() const;

		private:
			/// t@C
			FILE* mPFile;

			/// pX
			tstring mFullPathStr;
		};

	} // namespace IO
} // namespace

#endif // BLAST_IO_FILE_H