#ifndef BLAST_IO_CSVTABLE_H
#define BLAST_IO_CSVTABLE_H

#include <list>
#include "Blast/IO/CSVRecord.h"


namespace Blast
{
	namespace IO
	{
		/// CSṼf[^e[uSNX
		class CSVTable
		{
		public:
			//====================================================================================================
			// Alias
			//----------------------------------------------------------------------------------------------------

			// R[hXg
			typedef std::list< SP<CSVRecord> > RecordList;
			

			//====================================================================================================
			// Operation
			//----------------------------------------------------------------------------------------------------

			/// RXgN^
			CSVTable();
			
			/// fXgN^
			~CSVTable();


			/// R[hǉ
			void AddRecord(const SP<CSVRecord> rRecord);

			
			/// R[hXg
			void ClearRecord();


			/// R[h擾
			const SP<CSVRecord> GetRecord(int index) const;


			/// R[h擾
			int GetRecordCount() const;


			//====================================================================================================
			// Overload
			//----------------------------------------------------------------------------------------------------

			/// z񉉎ZqŃANZX\ɂ
			const SP<CSVRecord> operator[] (int index) const;

		private:
			/// R[hXg
			RecordList mRecordList;


			//====================================================================================================
			// PrivateOperation
			//----------------------------------------------------------------------------------------------------

			/// MEMO:`݂̂łB
			/// Rs[RXgN^֎~
			CSVTable(const CSVTable&);

			/// MEMO:`݂̂łB
			/// ֎~
			void operator= (const CSVTable&);


			/// CfbNXR[hXgɎ܂Ă邩ǂ
			bool IsIndexInList(int index) const;
		};

	} // namespace IO
} // namespace Blast

#endif // BLAST_IO_CSVTABLE_H