#ifndef BLAST_GRAPHIC_SPRITEIMAGE_H
#define BLAST_GRAPHIC_SPRITEIMAGE_H

#include "Blast/Graphic/ITexture2D.h"

namespace Blast
{
	namespace Graphic
	{
		/// XvCg̕`ɕKvȉ摜
		class SpriteImage
		{
			//====================================================================================================
			// Enumerate
			//----------------------------------------------------------------------------------------------------

		public:
			/// _̈ʒu̎
			enum EOrigin
			{
				eORIGIN_UP_LEFT,	///< 
				eORIGIN_UP_CENTER,	///< 
				eORIGIN_UP_RIGHT,	///< E
				eORIGIN_LEFT,		///< 
				eORIGIN_CENTER,		///< 
				eORIGIN_RIGHT,		///< E
				eORIGIN_DOWN_LEFT,	///< 
				eORIGIN_DOWN,		///< 
				eORIGIN_DOWN_RIGHT,	///< E

				eORIGIN_COUNT,		///< 񋓗vf̐
			};


			//====================================================================================================
			// Operation
			//----------------------------------------------------------------------------------------------------

		public:
			/// RXgN^
			SpriteImage();
			/// fXgN^
			~SpriteImage();

			/// XV
			void Update(float delta);
			/// `
			void Render();

			/// TCYeNX`TCYɑ
			void FitSizeToTextureSize();

			/// gk
			void Scaling(const Blast::Math::Vector2& kRScale);

			/// ]
			void Rotate(const Blast::Math::Vector3& kRRotate);

			/// ʒuړ
			void Translate(const Blast::Math::Vector3& kRTranslate);

			/// _ݒ
			void SetOrigin(EOrigin);
			/// _ړ
			void TranslateOrigin(const Blast::Math::Vector2& kRTranslate);


			//====================================================================================================
			// Property
			//----------------------------------------------------------------------------------------------------

		public:
			/// TCY擾
			const Blast::Math::Vector2& GetSize() const;
			/// TCYݒ
			void SetSize(const Blast::Math::Vector2& value);

			/// _擾
			const Blast::Math::Vector2& GetOrigin() const;
			/// _ݒ
			void SetOrigin(const Blast::Math::Vector2& value);

			/// gk擾
			const Blast::Math::Vector2& GetScale() const;
			/// gkݒ
			void SetScale(const Blast::Math::Vector2& value);

			/// ]l擾
			const Blast::Math::Vector3& GetRotation() const;
			/// ]lݒ
			void SetRotation(const Blast::Math::Vector3& value);

			/// ʒu擾
			const Blast::Math::Vector3& GetPosition() const;
			/// ʒuݒ
			void SetPosition(const Blast::Math::Vector3& value);

			/// F擾
			const Color& GetColor() const;
			/// Fݒ
			void SetColor(Color& value);

			/// [hs擾
			const Blast::Math::Matrix& GetWorld() const;

			/// eNX`擾
			const SP<ITexture2D> GetTexture() const;
			/// eNX`擾
			SP<ITexture2D> GetTexture();
			/// eNX`ݒ
			void SetTexture(SP<ITexture2D> value);


			//====================================================================================================
			// Field
			//----------------------------------------------------------------------------------------------------

		private:
			Blast::Math::Vector2	mSize;		///< TCY
			Blast::Math::Vector2	mOrigin;	///< _B]gk̊_ɂȂB
			Blast::Math::Vector2	mScale;		///< gk
			Blast::Math::Vector3	mRotation;	///< ]l
			Blast::Math::Vector3	mPosition;	///< ʒu
			Blast::Graphic::Color	mColor;		///< F
			
			Blast::Math::Matrix mWorld;		///< [hs

			SP<Blast::Graphic::ITexture2D> mPTexture;	///< 2DeNX`
			//SP<Blast::Graphic::MeshSprite> mPMesh;		///< bVBvȂB


			//====================================================================================================
			// Implement
			//----------------------------------------------------------------------------------------------------

		private:
		public:
			/// MEMO:O瓮IɌĂ΂邱Ƃ̂publicɔzu܂B
			/// ASpriteFont݂̂Ȃ̂ł͂ȂƂƂB
			/// [hsXV
			void UpdateWorldMatrix();
		};

	} // namespace Graphic
} // namespace Blast

#endif // BLAST_GRAPHIC_SPRITEIMAGE_H