#ifndef BLAST_GRAPHIC_MATERIALFBX_H
#define BLAST_GRAPHIC_MATERIALFBX_H

#include "Blast/Graphic/DirectX9/FileTexture2DDX9.h"


namespace Blast
{
	namespace Graphic
	{
		/// t@C}eAf[^LbVNX
		class MaterialFbx
		{
		public:
			//====================================================================================================
			// Struct
			//----------------------------------------------------------------------------------------------------

			/// J[`l
			struct SColorChannel
			{
			public:
				/// RXgN^
				SColorChannel::SColorChannel() :
					mTextureNameStr(_T("")),
					mColor(0xff000000)
				{
				}

				/// eNX`
				tstring mTextureNameStr;

				/// F
				Blast::Graphic::Color mColor;
			};


			//====================================================================================================
			// Operation
			//----------------------------------------------------------------------------------------------------

			/// RXgN^
			MaterialFbx();

			/// fXgN^
			~MaterialFbx();


			/// 
			void Initialize(const fbxsdk_2012_2::KFbxSurfaceMaterial* pMaterial);


			/// G~bVu擾
			SColorChannel* GetEmissive() { return &mEmissive; }

			/// ArGg擾
			SColorChannel* GetAmbient() { return &mAmbient; }

			/// fBt[Y擾
			SColorChannel* GetDiffuse() { return&mDiffuse; }

			/// XyL擾
			SColorChannel* GetSpecular() { return &mSpecular; }

			/// VClX擾
			float* GetShiness() { return &mShinness; }

		private:
			SColorChannel mEmissive;
			SColorChannel mAmbient;
			SColorChannel mDiffuse;
			SColorChannel mSpecular;
			float mShinness;
		};

	} // namespace Graphic
} // namespace Blast

#endif // BLAST_GRAPHIC_MATERIALFBX_H