#ifndef BLAST_GRAPHIC_ISPRITE_H
#define BLAST_GRAPHIC_ISPRITE_H

namespace Blast
{
	namespace Graphic
	{
		/// ITexture2D̃vg^Cv
		class ITexture2D;

		/// ICamerãvg^Cv
		class ICamera;


		/// XvCg̃C^[tF[X
		class ISprite
		{
		public:
			//====================================================================================================
			// Operation
			//----------------------------------------------------------------------------------------------------

			/// fXgN^
			virtual ~ISprite() { }


			/// XV
			virtual void Update(float) = 0;

			/// `
			virtual void Render() = 0;


			/// Jݒ
			virtual void SetCamera(SP<ICamera>) = 0;


			/// eNX`擾
			virtual SP<ITexture2D> GetTexture() = 0;

			/// eNX`擾
			virtual const SP<ITexture2D> GetTexture() const = 0;

			/// eNX`ݒ
			virtual void SetTexture(SP<ITexture2D>) = 0;


			/// TCY擾
			virtual Blast::Math::Vector2& GetSize() = 0;

			/// TCY擾
			virtual const Blast::Math::Vector2& GetSize() const = 0;

			/// TCYݒ
			virtual void SetSize(float width, float height) = 0;

			/// TCYݒ
			virtual void SetSize(const Blast::Math::Vector2&) = 0;


			/// MEMO:Ƃ肠floatɂĂ܂Aint̓ev[g̕ǂł傤B
			/// öݒ
			virtual void SetSourceRectangle(float topX, float topY, float bottomX, float bottomY) = 0;

			/// öݒ
			virtual void SetSourceRectangle(const Blast::Math::Vector2& kRLeftTop, const Blast::Math::Vector2& kRRightBottom) = 0;


			/// ʒu擾
			virtual const Blast::Math::Vector3& GetPosition() const = 0;

			/// ʒu擾
			virtual Blast::Math::Vector3& GetPosition() = 0;

			/// ʒuݒ
			virtual void SetPosition(float x, float y, float z) = 0;

			/// ʒuݒ
			virtual void SetPosition(const Blast::Math::Vector3&) = 0;

			/// ړ
			virtual void Move(float x, float y, float z) = 0;

			/// ړ
			virtual void Move(const Blast::Math::Vector3&) = 0;


			/// gk擾
			virtual const Blast::Math::Vector2& GetScale() const = 0;

			/// gk擾
			virtual Blast::Math::Vector2& GetScale() = 0;

			/// gkݒ
			virtual void SetScale(float width, float height) = 0;

			/// gkݒ
			virtual void SetScale(const Blast::Math::Vector2&) = 0;

			/// gk
			virtual void Scaling(float x, float y) = 0;

			/// gk
			virtual void Scaling(const Blast::Math::Vector2&) = 0;


			/// ]l擾
			virtual const Blast::Math::Vector3& GetRotation() const = 0;

			/// ]l擾
			virtual Blast::Math::Vector3& GetRotation() = 0;

			/// ]lݒ
			virtual void SetRotation(float radianX, float radianY, float radianZ) = 0;

			/// ]lݒ
			virtual void SetRotation(const Blast::Math::Vector3&) = 0;

			/// ]
			virtual void Rotate(float x, float y, float z) = 0;

			/// ]
			virtual void Rotate(const Blast::Math::Vector3&) = 0;


			/// S擾
			virtual const Blast::Math::Vector2& GetCenter() const = 0;

			/// S擾
			virtual Blast::Math::Vector2& GetCenter() = 0;

			/// Sݒ
			virtual void SetCenter(float x, float y) = 0;

			/// Sݒ
			virtual void SetCenter(const Blast::Math::Vector2&) = 0;

			/// Sړ
			virtual void MoveCenter(float x, float y) = 0;

			/// Sړ
			virtual void MoveCenter(const Blast::Math::Vector2&) = 0;


			/// UVWړ
			virtual void MoveUV(float moveU, float moveV) = 0;

			/// UVWړ
			virtual void MoveUV(const Blast::Math::Vector2&) = 0;

		private:
		};

	} // namespace Graphic
} // namespace Blast

#endif // BLAST_GRAPHIC_ISPRITE_H