#ifndef BLAST_GRAPHIC_IMODEL_H
#define BLAST_GRAPHIC_IMODEL_H

#include "Blast/Graphic/ICamera.h"


namespace Blast
{
	namespace Graphic
	{
		/// f̏SC^[tF[X
		class IModel
		{
		public:
			//====================================================================================================
			// Operation
			//----------------------------------------------------------------------------------------------------

			/// fXgN^
			virtual ~IModel() { }


			/// XV
			virtual void Update(float) = 0;

			/// `
			virtual void Render() = 0;


			/// gk擾
			virtual const Blast::Math::Vector3& GetScaleRef() const = 0;

			/// gkݒ
			virtual void SetScale(const Blast::Math::Vector3&) = 0;

			/// gk
			virtual void Scaling(const Blast::Math::Vector3&) = 0;


			/// ʒu擾
			virtual const Blast::Math::Vector3& GetPositionRef() const = 0;

			/// ʒuݒ
			virtual void SetPosition(const Blast::Math::Vector3&) = 0;

			/// ړ
			virtual void Move(const Blast::Math::Vector3&) = 0;


			/// ]擾
			virtual const Blast::Math::Vector3& GetRotationRef() const = 0;

			/// ]ݒ
			virtual void SetRotation(const Blast::Math::Vector3&) = 0;

			/// ]
			virtual void Rotate(const Blast::Math::Vector3&) = 0;


			/// J擾
			virtual SP<Blast::Graphic::ICamera> GetCamera() = 0;

			/// Jݒ
			virtual void SetCamera(SP<Blast::Graphic::ICamera>) = 0;


			/// eNjbNݒ
			virtual void SetTechnique(int) = 0;
			
			/// eNjbNݒ
			virtual void SetTechnique(const TCHAR*) = 0;


			/// Aj[VύX
			virtual void ChangeAnimation(int) = 0;

			/// Aj[VύX
			virtual void ChangeAnimation(const TCHAR*) = 0;
			

			/// bVǂݍ
			virtual bool LoadMesh(const TCHAR* kPFullPath) = 0;


			/// Aj[V̓ǂݍ
			virtual bool LoadAnimation(const TCHAR* kPFullPath) = 0;
			
			/// Aj[VJ
			virtual void ReleaseAnimation() = 0;
		};

	} // namespace Graphic
} // namespace Blast

#endif // BLAST_GRAPHIC_IMODEL_H