#ifndef BLAST_GRAPHIC_TEXTURE2DDX9_H
#define BLAST_GRAPHIC_TEXTURE2DDX9_H

#include "Blast/Graphic/ITexture2D.h"


namespace Blast
{
	namespace Graphic
	{
		/// DirectX9p2DeNX`ێ鏈SNX
		class Texture2DDX9 : public Blast::Graphic::ITexture2D
		{
		public:
			//====================================================================================================
			// Operation
			//----------------------------------------------------------------------------------------------------

			/// RXgN^
			Texture2DDX9();

			/// fXgN^
			virtual ~Texture2DDX9();


			/// 擾
			virtual int GetWidth() const;

			/// c擾
			virtual int GetHeight() const;


			//====================================================================================================
			// Property
			//----------------------------------------------------------------------------------------------------

			/// eNX`ݒ
			void SetTexture(CSP<IDirect3DTexture9>& rPTexture)
			{
				// eNX`ێ
				mPTexture = rPTexture;

				// T[tFCX쐬
				CreateSurfaceByTexture();
			}

			/// eNX`擾
			const CSP<IDirect3DTexture9>& GetTexturePtrRef() const
			{
				return mPTexture;
			}

			/// eNX`擾
			CSP<IDirect3DTexture9>& GetTexturePtrRef()
			{
				return mPTexture;
			}


			/// T[tFCX擾
			CSP<IDirect3DSurface9>& GetSurfacePtrRef()
			{
				return mPSurface;
			}


			// T[tFCX擾
			const D3DSURFACE_DESC& GetSurfaceDescriptionRef() const
			{
				return mSurfaceDescription;
			}

		protected:
			/// eNX`
			CSP<IDirect3DTexture9> mPTexture;
			

			// T[tFCX
			CSP<IDirect3DSurface9> mPSurface;

			// T[tFCX
			D3DSURFACE_DESC mSurfaceDescription;

			
			//====================================================================================================
			// ProtectedOperation
			//----------------------------------------------------------------------------------------------------

			/// eNX`T[tFCX֘Ȁ쐬
			void CreateSurfaceByTexture();
		};

	} // namespace Graphic
} // namespace Blast

#endif // BLAST_GRAPHIC_TEXTURE2DDX9_H