#ifndef BLAST_GRAPHIC_STATICMESHDX9_H
#define BLAST_GRAPHIC_STATICMESHDX9_H

#include "Blast/Base/IResource.h"
#include "Blast/Graphic/IMesh.h"
#include "Blast/Graphic/DirectX9/VertexBufferDX9.h"
#include "Blast/Graphic/DirectX9/IndexBufferDX9.h"
#include "Blast/Graphic/DirectX9/VertexDeclarationDX9.h"
#include "Blast/Graphic/DirectX9/ShaderEffectDX9.h"
#include "Blast/Graphic/SkeletonFbx.h"
#include "Blast/Graphic/ITexture2D.h"


namespace Blast
{
	namespace Graphic
	{
		/// ÓIFBXt@C̃bVێNX
		class StaticMeshDX9
			//: public Blast::Base::IResource
			//, public Blast::Graphic::IMesh
		{
		public:
			//====================================================================================================
			// Enumerate
			//----------------------------------------------------------------------------------------------------

			/// _obt@̎
			enum EVertexBuffer
			{
				eVERTEXBUFFER_POSITION,			///< ʒu
				eVERTEXBUFFER_UV,				///< UV
				eVERTEXBUFFER_NORMAL,			///< @
				eVERTEXBUFFER_INSTANCE_INDEX,	///< CX^XCfbNX

				/// 񋓗vf̐
				eVERTEXBUFFER_COUNT,
			};


			//====================================================================================================
			// Static
			//----------------------------------------------------------------------------------------------------

			/// CX^X̃CfbNX̍ő吔B
			/// VF[_[萔z̗vfĂKvB
			static const int MAX_INSTANCE_INDEX = 5;


			//====================================================================================================
			// Struct
			//----------------------------------------------------------------------------------------------------

			struct SSubMesh
			{
			public:
				/// RXgN^
				SSubMesh()
					: mIndexOffset(0)
					, mTriangleCount(0)
				{}

				/// CfbNX̃ItZbg
				int mIndexOffset;

				/// Op`|S̐
				int mTriangleCount;
			};


			//====================================================================================================
			// Operation
			//----------------------------------------------------------------------------------------------------

			/// RXgN^
			StaticMeshDX9();

			/// fXgN^
			virtual ~StaticMeshDX9();

			/// 
			void Initialize(fbxsdk_2012_2::KFbxNode* pFbxNode, fbxsdk_2012_2::KFbxMesh* pFbxMesh);

			// MEMO:bV󂯎ĉ͂փVtgȂ̂ŃtbN邾ɂĂ
			/// ǂݍ
			virtual bool Load(const TCHAR* const kPFullPath) { return false; }

			/// `ȌsBVF[_[ŃpX񂷑OɍszB
			void BeginRender();

			/// `
			void Render(int materialIndex);


			/// CX^Xǉ
			void AddInstance(int count);
			/// CX^XO
			void RemoveInstance(int count);


			/// m[h擾
			fbxsdk_2012_2::KFbxNode* GetNode() { return mPFbxNode; }

			/// bV擾
			fbxsdk_2012_2::KFbxMesh* GetMesh() { return mPFbxMesh; }

			/// TubV̐擾
			int GetSubMeshCount() const { return mSubMeshes.GetCount(); }


		private:
			/// Fbxm[h
			fbxsdk_2012_2::KFbxNode* mPFbxNode;

			/// FbxbV
			fbxsdk_2012_2::KFbxMesh* mPFbxMesh;

			// MEMO:bV擾ł̂ł킴킴ϐɂȂłB
			///// |S̐
			//int mPolygonCount;

			/// _̐
			int mVertexCount;

			/// e풸_
			SP<float> mPVertices[eVERTEXBUFFER_COUNT];

			/// CfbNX
			SP<int> mPIndices;

			/// o[ebNXobt@Q
			SP<Blast::Graphic::VertexBufferDX9> mPVertexBuffers[eVERTEXBUFFER_COUNT];

			/// _`
			SP<Blast::Graphic::VertexDeclarationDX9> mPVertexDeclaration;

			/// CfbNXobt@Q
			SP<Blast::Graphic::IndexBufferDX9> mPIndexBuffer;

			/// TubVQ
			fbxsdk_2012_2::KArrayTemplate<SSubMesh*> mSubMeshes;

			/// CX^X̐BIWȉ1ƂăJEgB
			int mInstanceCount;

			bool mIsHasNormal;			///< @邩ǂ
			bool mIsHasUV;				///< UV邩ǂ
		    bool mIsAllByControlPoint;	///< Save data in VBO by control point or by polygon vertex.

			
			//====================================================================================================
			// Implement
			//----------------------------------------------------------------------------------------------------

			/// CX^XύXɂobt@̍č쐬s
			void ReCreateBuffers();
		};

	} // namespace
} // namespace Blast

#endif // BLAST_GRAPHIC_STATICMESHDX9_H