#ifndef BLAST_GRAPHIC_SPRITEFONTDX9_H
#define BLAST_GRAPHIC_SPRITEFONTDX9_H

#include <map>
#include "Blast/Base/RenderableGameComponent.h"
#include "Blast/Graphic/Font.h"
#include "Blast/Graphic/ITexture2D.h"
#include "Blast/Graphic/DirectX9/SpriteDX9.h"
#include "Blast/Graphic/SpriteImage.h"


namespace Blast
{
	namespace Graphic
	{
		/// XvCgtHg̏NX
		class SpriteFontDX9 :
			public Blast::Base::RenderableGameComponent,
			public Blast::Graphic::Font
		{
		public:
			//====================================================================================================
			// Struct
			//----------------------------------------------------------------------------------------------------

			/// eNX`
			struct SFontTextureDatas
			{
			public:
				//====================================================================================================
				// Operation
				//----------------------------------------------------------------------------------------------------

				/// RXgN^
				SFontTextureDatas();


				//====================================================================================================
				// Field
				//----------------------------------------------------------------------------------------------------

				/// R[h
				unsigned mCode;

				/// 
				TCHAR mCharacter;

				/// tHgeNX`
				SP<ITexture2D> mPTexture;

			private:
			};


			//====================================================================================================
			// Alias
			//----------------------------------------------------------------------------------------------------

			/// R[hƕ̃}bv̌^
			typedef std::map<unsigned, SFontTextureDatas> SFontTextureDataMap;


			//====================================================================================================
			// Operation
			//----------------------------------------------------------------------------------------------------

			/// RXgN^
			SpriteFontDX9(
				const TCHAR* kPFontName = Blast::Graphic::Font::stKPFontName,
				int fontSize = Blast::Graphic::Font::stKFontSize,
				int fontWeight = Blast::Graphic::Font::stKFontWeight);

			/// fXgN^
			virtual ~SpriteFontDX9();


			/// `悷镶ݒ
			virtual void SetText(const TCHAR* const);


			/// `
			virtual void Render();


			/// ̗̈̒擾
			virtual int MeasureString(const TCHAR* const) const;


			/// XV
			void Update(float);

			
			//====================================================================================================
			// Property
			//----------------------------------------------------------------------------------------------------

			/// XvCg擾
			SP<SpriteDX9> GetSprite() { return mPSprite; }

			/// XvCg擾
			const SP<SpriteDX9> GetSprite() const { return mPSprite; }

		private:
			/// XvCg
			SP<SpriteDX9> mPSprite;

			/// C[W
			SP<SpriteImage> mPImage;

			/// eNX`Q
			SFontTextureDataMap mSFontTextureDataMap;
		};

	} // Graphic
} // namespace Blast

#endif // BLAST_GRAPHIC_SPRITEFONTDX9_H