#ifndef BLAST_GRAPHIC_PRIMITIVEMODELDX9_H
#define BLAST_GRAPHIC_PRIMITIVEMODELDX9_H

// MEMO:C^[tF[Xɒu܂B
#include "Blast/Base/RenderableGameComponent.h"
#include "Blast/Graphic/IMesh.h"
#include "Blast/Graphic/ICamera.h"
#include "Blast/Graphic/DirectX9/ShaderEffectDX9.h"
#include "Blast/Math/WorldProperty.h"


namespace Blast
{
	namespace Graphic
	{
		/// {`󃁃bV̕`֘ȀSNX
		class PrimitiveModelDX9 : public Blast::Base::RenderableGameComponent
		{
		public:
			//====================================================================================================
			// Operation
			//----------------------------------------------------------------------------------------------------

			/// RXgN^
			PrimitiveModelDX9();

			/// fXgN^
			virtual ~PrimitiveModelDX9();


			/// XV
			virtual void Update(float);

			/// `
			virtual void Render();


			/// bVݒ
			void SetMesh(SP<IMesh> pMesh) { mPMesh = pMesh; }


			/// F擾
			Blast::Graphic::Color& GetColor() { return mColor; }

			/// F擾
			const Blast::Graphic::Color& GetColor() const { return mColor; }

			/// Fݒ
			void SetColor(const Blast::Graphic::Color& kRColor) { mColor = kRColor; }


			/// gk擾
			Blast::Math::Vector3& GetScale() { return mScale; }

			/// gk擾
			const Blast::Math::Vector3& GetScale() const { return mScale; }

			/// gk擾
			void SetScale(const Blast::Math::Vector3& kRScale) { mScale = kRScale; }


			/// ]
			void Rotate(const Blast::Math::Vector3& kRRotation) { mRotation += kRRotation; }

			/// ]擾
			Blast::Math::Vector3& GetRotate() { return mRotation; }

			/// ]擾
			const Blast::Math::Vector3& GetRotate() const { return mRotation; }

			/// ]ݒ
			void SetRotate(const Blast::Math::Vector3& kRRotate) { mRotation = kRRotate; }


			/// ʒu擾
			Blast::Math::Vector3& GetPositon() { return mPosition; }

			/// ʒu擾
			const Blast::Math::Vector3& GetPositon() const { return mPosition; }

			/// ʒuݒ
			void SetPosition(const Blast::Math::Vector3& kRPosition) { mPosition = kRPosition; }


			/// Jݒ
			void SetCamera(SP<Blast::Graphic::ICamera> pCamera) { mPCamera = pCamera; }


			/// VF[_[GtFNg擾
			SP<Blast::Graphic::ShaderEffectDX9> GetShaderEffect() { return mPShaderEffect; }

		private:
			/// bV
			SP<IMesh> mPMesh;

			/// F
			Color mColor;


			/// gk
			Blast::Math::Vector3 mScale;

			/// ]
			Blast::Math::Vector3 mRotation;

			/// ʒu
			Blast::Math::Vector3 mPosition;


			/// J
			SP<ICamera> mPCamera;

			/// VF[_[GtFNg
			SP<ShaderEffectDX9> mPShaderEffect;
		};

	} // namespace Graphic
} // namespace Blast

#endif // BLAST_GRAPHIC_PRIMITIVEMODELDX9_H