#ifndef BLAST_GRAPHIC_POLYGONTRIANGLEDX9_H
#define BLAST_GRAPHIC_POLYGONTRIANGLEDX9_H

#include "Blast/Math/Matrix.h"
#include "Blast/Math/WorldProperty.h"
#include "Blast/Graphic/DirectX9/VertexBufferDX9.h"
#include "Blast/Graphic/DirectX9/IndexBufferDX9.h"
#include "Blast/Graphic/DirectX9/VertexDeclarationDX9.h"
#include "Blast/Graphic/DirectX9/ShaderEffectDX9.h"


namespace Blast
{
	namespace Graphic
	{
		/// DirectX9p̎Op`|S̏ێNX
		class PolygonTriangleDX9
		{
		public:
			//====================================================================================================
			// Struct
			//----------------------------------------------------------------------------------------------------

			/// MEMO:ǂɂ܂Ƃ߂ǂ܂B
			/// o[ebNX
			struct SVertex
			{
				/// ʒuWX
				float mX;

				/// ʒuWY
				float mY;

				/// ʒuWZ
				float mZ;
			};


			//====================================================================================================
			// Operation
			//----------------------------------------------------------------------------------------------------

			/// RXgN^
			PolygonTriangleDX9();

			/// fXgN^
			virtual ~PolygonTriangleDX9();

			/// o[ebNXobt@쐬
			virtual void CreateVertexBuffer();

			/// _`쐬
			virtual void CreateVertexDeclaration();

			/// CfbNXobt@쐬
			virtual void CreateIndexBuffer();

			/// VF[_[GtFNg쐬
			virtual void CreateShaderEffect();

			/// XV
			virtual void Update(float delta);

			/// `
			virtual void Render();


			/// 
			void Intialize();

			/// r[sƎˉesݒ
			void SetViewProjection(const Blast::Math::Matrix& kRView, const Blast::Math::Matrix& kRProjection);

		private:
			/// o[ebNXobt@
			SP<VertexBufferDX9> mPVertexBuffer;

			/// CfbNXobt@
			SP<IndexBufferDX9> mPIndexBuffer;

			/// _錾
			SP<VertexDeclarationDX9> mPVertexDeclaration;

			/// VF[_[GtFNg
			SP<ShaderEffectDX9> mPShaderEffect;

			/// [h
			Blast::Math::WorldProperty mWorldMatrixProperty;

			/// r[s
			Blast::Math::Matrix mViewMatrix;

			/// ˉes
			Blast::Math::Matrix mProjectionMatrix;
		};

	} // namespace Graphic
} // namespace Blsat

#endif // BLAST_GRAPHIC_POLYGONTRIANGLEDX9_H