#ifndef BLAST_GRAPHIC_MESHFBXSTATICDX9_H
#define BLAST_GRAPHIC_MESHFBXSTATICDX9_H

#include "Blast/Base/IResource.h"
#include "Blast/Graphic/IMesh.h"
#include "Blast/Graphic/DirectX9/VertexBufferDX9.h"
#include "Blast/Graphic/DirectX9/IndexBufferDX9.h"
#include "Blast/Graphic/DirectX9/VertexDeclarationDX9.h"
#include "Blast/Graphic/DirectX9/ShaderEffectDX9.h"
#include "Blast/Graphic/SkeletonFbx.h"
#include "Blast/Graphic/ITexture2D.h"


namespace Blast
{
	namespace Graphic
	{
		/// FBXt@C̃bVێNX
		class MeshFbxStaticDX9 :
			public Blast::Base::IResource,
			public Blast::Graphic::IMesh
		{
		public:
			//====================================================================================================
			// Enumerate
			//----------------------------------------------------------------------------------------------------

			/// _obt@̎
			enum EVertexBuffer
			{
				eVERTEXBUFFER_POSITION,		///< ʒu
				eVERTEXBUFFER_UV,			///< UV
				eVERTEXBUFFER_NORMAL,		///< @
				eVERTEXBUFFER_BONE_INDEX,	///< {[CfbNX
				eVERTEXBUFFER_BONE_WEIGHT,	///< {[EFCg

				/// 񋓗vf̐
				eVERTEXBUFFER_COUNT,
			};


			//====================================================================================================
			// Struct
			//----------------------------------------------------------------------------------------------------

			struct SSubMesh
			{
			public:
				/// RXgN^
				SSubMesh() :
					mIndexOffset(0),
					mTriangleCount(0)
				{
				}

				/// CfbNX̃ItZbg
				int mIndexOffset;

				/// Op`|S̐
				int mTriangleCount;
			};


			//====================================================================================================
			// Operation
			//----------------------------------------------------------------------------------------------------

			/// RXgN^
			MeshFbxStaticDX9();

			/// fXgN^
			virtual ~MeshFbxStaticDX9();


			/// 
			void Initialize(fbxsdk_2012_2::KFbxNode* pFbxNode, fbxsdk_2012_2::KFbxMesh* pFbxMesh);


			// MEMO:bV󂯎ĉ͂փVtgȂ̂ŃtbN邾ɂĂ
			/// ǂݍ
			virtual bool Load(const TCHAR* const kPFullPath) { return false; }

			/// UNDONE:}eA̎w肪KvłAC^[tF[X̃\bhȂ̂ŃtbNŗ߂ĂB
			/// `
			virtual void Render() { }
			void BeginRender();
			virtual void Render(int materialIndex);


			/// m[h擾
			fbxsdk_2012_2::KFbxNode* GetNode() { return mPFbxNode; }

			/// bV擾
			fbxsdk_2012_2::KFbxMesh* GetMesh() { return mPFbxMesh; }


			/// TubV̐擾
			int GetSubMeshCount() const { return mSubMeshes.GetCount(); }


			/// _̈ʒuXV
			void UpdateVertexPosition(const fbxsdk_2012_2::KFbxMesh* kPMesh, const fbxsdk_2012_2::KFbxVector4* kPVertices);

		private:
			/// o[ebNXobt@Q
			SP<Blast::Graphic::VertexBufferDX9> mPVertexBuffers[eVERTEXBUFFER_COUNT];

			/// _`
			SP<Blast::Graphic::VertexDeclarationDX9> mPVertexDeclaration;

			/// CfbNXobt@Q
			SP<Blast::Graphic::IndexBufferDX9> mPIndexBuffer;


			/// Fbxm[h
			fbxsdk_2012_2::KFbxNode* mPFbxNode;

			/// FbxbV
			fbxsdk_2012_2::KFbxMesh* mPFbxMesh;


			/// TubVQ
			fbxsdk_2012_2::KArrayTemplate<SSubMesh*> mSubMeshes;


			bool mIsHasNormal;			///< @邩ǂ
			bool mIsHasUV;				///< UV邩ǂ
			bool mIsHasSkin;			///< XL邩ǂ
		    bool mIsAllByControlPoint;	///< Save data in VBO by control point or by polygon vertex.


			/// q
			std::vector< SP<MeshFbxStaticDX9> > mChildrenPtrs;


			//====================================================================================================
			// PrivateOperation
			//----------------------------------------------------------------------------------------------------

			/// ċAǂݍ
			void LoadRecursive(const TCHAR* kPFullPath, fbxsdk_2012_2::KFbxNode* pRootNode);

			/// bVǂݍ
			void LoadMesh(const TCHAR* kPFullPath, fbxsdk_2012_2::KFbxMesh*);

			/// }eAǂݍ
			void LoadMaterial(const TCHAR* kPFullPath, fbxsdk_2012_2::KFbxNode* pMeshNode);
		};

	} // namespace
} // namespace Blast

#endif // BLAST_GRAPHIC_MESHFBXSTATICDX9_H