#ifndef BLAST_GRAPHIC_MESHFBXDX9_H
#define BLAST_GRAPHIC_MESHFBXDX9_H

#include "Blast/Base/IResource.h"
#include "Blast/Graphic/DirectX9/MeshDX9.h"
#include "Blast/Graphic/DirectX9/VertexBufferDX9.h"
#include "Blast/Graphic/DirectX9/IndexBufferDX9.h"
#include "Blast/Graphic/DirectX9/VertexDeclarationDX9.h"
#include "Blast/Graphic/DirectX9/ShaderEffectDX9.h"
#include "Blast/Graphic/SkeletonFbx.h"
#include "Blast/Graphic/ITexture2D.h"


namespace Blast
{
	namespace Graphic
	{
		/// FBXt@C̃bVێNX
		class MeshFbxDX9 :
			public Blast::Base::IResource,
			public Blast::Graphic::MeshDX9
		{
		public:
			//====================================================================================================
			// Enumerate
			//----------------------------------------------------------------------------------------------------

			/// _obt@̎
			enum EVertexBuffer
			{
				/// ʒu
				eVERTEXBUFFER_POSITION,

				/// UV
				eVERTEXBUFFER_UV,

				/// @
				eVERTEXBUFFER_NORMAL,

				/// {[CfbNX
				eVERTEXBUFFER_BONE_INDEX,

				/// {[EFCg
				eVERTEXBUFFER_BONE_WEIGHT,


				/// 񋓗vf̐
				eVERTEXBUFFER_COUNT,
			};


			//====================================================================================================
			// Struct
			//----------------------------------------------------------------------------------------------------

			/// }eA
			struct SMaterial
			{
			public:
				/// }eA
				tstring mNameStr;

				/// ArGg
				Blast::Math::Vector3 mAmbient;

				// ArGg̋
				float mAmbientFactor;

				/// fBt[Y
				Blast::Math::Vector3 mDiffuse;

				/// fBt[Y̋
				float mDiffuseFactor;

				/// XyL
				Blast::Math::Vector3 mSpecular;

				/// XyL̋
				float mSpecularFactor;

				/// VClX
				float mShininess;


				/// MEMO:eNX`ɑΉǂł傤BUV̎CɂȂ܂B
				/// fBt[YeNX`
				SP<Blast::Graphic::ITexture2D> mPDiffuseTexture;


				/// v~eBu
				unsigned mPrimitiveCount;


				/// RXgN^
				SMaterial()
				{
					mNameStr = _T("");
					mAmbient = Blast::Math::Vector3::Zero();
					mAmbientFactor = 1;
					mDiffuse = Blast::Math::Vector3::Zero();
					mDiffuseFactor = 1;
					mSpecular = Blast::Math::Vector3::Zero();
					mSpecularFactor = 1;
					mShininess = 0;

					mPrimitiveCount = 0;
				}

			private:
			};


			//====================================================================================================
			// Operation
			//----------------------------------------------------------------------------------------------------

			/// RXgN^
			MeshFbxDX9();

			/// fXgN^
			virtual ~MeshFbxDX9();


			/// ǂݍ
			virtual bool Load(const TCHAR* const kPFullPath);


			/// XV
			virtual void Update(float);

			/// `
			virtual void Render();


			/// r[sݒ
			virtual void SetView(const Blast::Math::Matrix&);

			/// ˉesݒ
			virtual void SetProjection(const Blast::Math::Matrix&);

			
			/// XPgݒ
			virtual void SetSkeleton(SP<Blast::Graphic::ISkeleton>);

			/// Aj[Vݒ
			virtual void SetAnimation(SP<Blast::Graphic::IAnimation>);

		private:
			/// o[ebNXobt@Q
			SP<Blast::Graphic::VertexBufferDX9> mPVertexBuffers[eVERTEXBUFFER_COUNT];

			/// CfbNXobt@Q
			std::vector< SP<Blast::Graphic::IndexBufferDX9> > mIndexBufferPtrs;


			/// _`
			SP<Blast::Graphic::VertexDeclarationDX9> mPVertexDeclaration;


			/// }eAQ
			SP<SMaterial> mPSMaterials;

			/// }eA̐
			int mMaterialCount;


			/// Fbx}l[W[
			fbxsdk_2012_2::KFbxSdkManager* mPFbxSdkManager;

			/// FbxV[
			fbxsdk_2012_2::KFbxScene* mPFbxScene;

			/// FbxbV
			fbxsdk_2012_2::KFbxMesh* mPFbxMesh;


			/// q
			std::vector< SP<MeshFbxDX9> > mChildrenPtrs;


			//====================================================================================================
			// PrivateOperation
			//----------------------------------------------------------------------------------------------------

			/// ċAǂݍ
			void LoadRecursive(const TCHAR* kPFullPath, fbxsdk_2012_2::KFbxNode* pRootNode);

			/// bVǂݍ
			void LoadMesh(const TCHAR* kPFullPath, fbxsdk_2012_2::KFbxMesh*);

			/// }eAǂݍ
			void LoadMaterial(const TCHAR* kPFullPath, fbxsdk_2012_2::KFbxNode* pMeshNode);
		};

	} // namespace
} // namespace Blast

#endif // BLAST_GRAPHIC_MESHFBXDX9_H