#ifndef BLAST_GRAPHIC_DEBUGPRINTDX9_H
#define BLAST_GRAPHIC_DEBUGPRINTDX9_H

#include <vector>
#include "Blast/Graphic/IDebugPrint.h"
#include "Blast/Graphic/DirectX9/FontDX9.h"

namespace Blast
{
	namespace Graphic
	{
		/// DirectX9pAfobO\p̕`悷鏈SNX
		class DebugPrintDX9 : public Blast::Graphic::IDebugPrint
		{
			//====================================================================================================
			// Struct
			//----------------------------------------------------------------------------------------------------

		public:
			/// ͏
			struct SSentence
			{
				Blast::Math::Vector3	mPosition;	///< ʒu
				Blast::Graphic::Color	mColor;		///< F
				TCHAR					mText[128];	///< 
			};


			//====================================================================================================
			// Alias
			//----------------------------------------------------------------------------------------------------

		public:
			/// ̓Xg
			typedef std::vector<SSentence> SentenceList;


			//====================================================================================================
			// Operation
			//----------------------------------------------------------------------------------------------------

		public:
			/// RXgN^
			DebugPrintDX9();
			/// fXgN^
			virtual ~DebugPrintDX9();

			/// tHgTCY擾
			virtual int GetPointSize() const override;

			/// ʒuݒ
			virtual void SetPosition(const Blast::Math::Vector3& kRPosition) override;

			/// Fݒ
			virtual void SetColor(const Color& kRColor) override;
			/// ݒ
			virtual void SetText(const TCHAR* pText) override;

			/// `
			virtual void Render() override;
			/// `ʂɔf
			virtual void Flush() override;


			//====================================================================================================
			// Property
			//----------------------------------------------------------------------------------------------------

			/// tHg擾
			const SP<Blast::Graphic::FontDX9> GetFont() const;


			//====================================================================================================
			// Field
			//----------------------------------------------------------------------------------------------------

		private:
			/// tHg
			SP<Blast::Graphic::FontDX9> mPFont;

			/// ̓Xg
			SentenceList mSentenceList;

			/// ݂͐̕ݒBRenderɂ̒lXgɒǉB
			SSentence mSSentence;
		};

	} // namespace Graphic
} // namespace Blast

#endif // BLAST_GRAPHIC_DEBUGPRINTDX9_H