#ifndef BLAST_GRAPHIC_BTMODELSTATICDX9_H
#define BLAST_GRAPHIC_BTMODELSTATICDX9_H

#include <map>
#include "Blast/Base/RenderableGameComponent.h"
#include "Blast/Graphic/IModel.h"
#include "Blast/Graphic/ICamera.h"
#include "Blast/Graphic/DirectX9/Texture2DDX9.h"
#include "Blast/Graphic/DirectX9/MeshFbxStaticDX9.h"
#include "Blast/Graphic/DirectX9/ShaderEffectDX9.h"
#include "Blast/Graphic/MaterialFbx.h"
#include "Blast/Graphic/SkeletonStaticFbx.h"


namespace Blast
{
	namespace Graphic
	{
		/// ėpfNX
		class BtModelStaticDX9 :
			public Blast::Graphic::IModel,
			public Blast::Base::RenderableGameComponent
		{
		public:
			//====================================================================================================
			// Operation
			//----------------------------------------------------------------------------------------------------

			/// RXgN^
			BtModelStaticDX9();

			/// fXgN^
			virtual ~BtModelStaticDX9();


			/// XV
			virtual void Update(float);

			/// `
			virtual void Render();


			/// gk擾
			virtual const Blast::Math::Vector3& GetScaleRef() const { return mScale; }

			/// gkݒ
			virtual void SetScale(const Blast::Math::Vector3& kRScale) { mScale = kRScale; }

			/// gks
			virtual void Scaling(const Blast::Math::Vector3& kRScale) { mScale += kRScale; }


			/// ʒu擾
			virtual const Blast::Math::Vector3& GetPositionRef() const { return mPosition; }

			/// ʒuݒ
			virtual void SetPosition(const Blast::Math::Vector3& kRValue) { mPosition = kRValue; }

			/// ړs
			virtual void Move(const Blast::Math::Vector3& kRValue) { mPosition += kRValue; }


			/// ]擾
			virtual const Blast::Math::Vector3& GetRotationRef() const { return mRotation; }

			/// ]ݒ
			virtual void SetRotation(const Blast::Math::Vector3& kRValue) { mRotation = kRValue; }

			/// ]s
			virtual void Rotate(const Blast::Math::Vector3& kRValue) { mRotation += kRValue; }


			/// J擾
			virtual SP<Blast::Graphic::ICamera> GetCamera() { return mPCamera; }

			/// Jݒ
			virtual void SetCamera(SP<Blast::Graphic::ICamera> pCamera) { mPCamera = pCamera; }


			/// VF[_[擾
			SP<Blast::Graphic::ShaderEffectDX9> GetShaderEffect() { return mPShaderEffect; }

			/// VF[_[ݒ
			void SetShaderEffect(SP<Blast::Graphic::ShaderEffectDX9> pValue) { mPShaderEffect = pValue; }

			/// MEMO:ꏈύX̂߁AtbNĂB
			/// eNjbNݒ
			virtual void SetTechnique(int) { }
			
			/// MEMO:ꏈύX̂߁AtbNĂB
			/// eNjbNݒ
			virtual void SetTechnique(const TCHAR*) { }


			/// MEMO:ꏈύX̂߁AtbNĂB
			/// Aj[VύX
			virtual void ChangeAnimation(int) { }

			/// MEMO:ꏈύX̂߁AtbNĂB
			/// Aj[VύX
			virtual void ChangeAnimation(const TCHAR*) { }


			/// bVǂݍ
			virtual bool LoadMesh(const TCHAR* kPFullPath);


			/// MEMO:ꏈύX̂߁AtbNĂB
			/// Aj[V̓ǂݍ
			virtual bool LoadAnimation(const TCHAR* kPFullPath) { return false; }

			/// MEMO:ꏈύX̂߁AtbNĂB
			/// Aj[VJ
			virtual void ReleaseAnimation() { }
			

			/// bV擾
			SP<Blast::Graphic::MeshFbxStaticDX9> GetMesh() { return mPMesh; }

			/// ݂̃|[Y擾
			int GetCurrentPose() const { return mCurrentPoseIndex; }

			/// ݂̃|[Yݒ
			void SetCurrentPose(int index) { mCurrentPoseIndex = index; }

		private:
			/// bV
			SP<Blast::Graphic::MeshFbxStaticDX9> mPMesh;

			/// gk
			Blast::Math::Vector3 mScale;

			/// ]
			Blast::Math::Vector3 mRotation;

			/// ʒu
			Blast::Math::Vector3 mPosition;

			/// J
			SP<Blast::Graphic::ICamera> mPCamera;

			/// VF[_[GtFNg
			SP<Blast::Graphic::ShaderEffectDX9> mPShaderEffect;
			
			/// eNX`Q
			std::map<tstring, SP<Blast::Graphic::Texture2DDX9>> mPMaterialTextures;

			/// }eAQ
			std::vector< SP<MaterialFbx> > mPMaterials;

			/// ݂̃|[ỸCfbNX
			int mCurrentPoseIndex;

			/// Fbx}l[W[
			fbxsdk_2012_2::KFbxSdkManager* mPFbxSdkManager;

			/// FbxV[
			fbxsdk_2012_2::KFbxScene* mPFbxScene;

			/// Fbx|[YQ
			fbxsdk_2012_2::KArrayTemplate<KFbxPose*> mFbxPoseArray;

			/// XPg
			SP<Blast::Graphic::SkeletonStaticFbx> mPSkeleton;


			//====================================================================================================
			// PrivateOperation
			//----------------------------------------------------------------------------------------------------

			/// Bake node attributes and materials for this scene and load the textures.
			void LoadCacheRecursive(fbxsdk_2012_2::KFbxScene*, const TCHAR* pFbxFileName);

			// Bake node attributes and materials under this node recursively.
			// Currently only mesh, light and material.
			void LoadCacheRecursive(fbxsdk_2012_2::KFbxNode* pNode);

			/// }eAǂݍ
			void LoadCacheMaterial(fbxsdk_2012_2::KFbxSurfaceMaterial* pMaterial);


			/// m[hċA`悷
			void RenderNodeRecursive(
				fbxsdk_2012_2::KFbxNode* pNode,
				fbxsdk_2012_2::KTime& pTime,
				fbxsdk_2012_2::KFbxAnimLayer* pAnimLayer,
				fbxsdk_2012_2::KFbxPose* pPose,
				fbxsdk_2012_2::KFbxXMatrix& rParentGlobalPostion
				);

			/// m[h`BRenderNodeRecursive̍ċA`撆ɌĂ΂B
			void RenderNode(
				fbxsdk_2012_2::KFbxNode* pNode,
				fbxsdk_2012_2::KTime& rTime,
				fbxsdk_2012_2::KFbxAnimLayer* pAnimLayer,
				fbxsdk_2012_2::KFbxPose* pPose,
				fbxsdk_2012_2::KFbxXMatrix& rParentGlobalPostion,
				fbxsdk_2012_2::KFbxXMatrix& rGlobalPostion
				);

			/// bV`
			void RenderMesh(
				fbxsdk_2012_2::KFbxNode* pNode,
				fbxsdk_2012_2::KTime& pTime,
				fbxsdk_2012_2::KFbxAnimLayer* pAnimLayer,
				fbxsdk_2012_2::KFbxPose* pPose,
				fbxsdk_2012_2::KFbxXMatrix& rGlobalPosition
				);
		};

	} // namespace Graphic
} // namespace Blast

#endif // BLAST_GRAPHIC_BTMODELSTATICDX9_H