#ifndef BLAST_GRAPHIC_COLOR_H
#define BLAST_GRAPHIC_COLOR_H

#include "Blast/Graphic/ColorCode.h"


namespace Blast
{
	namespace Graphic
	{
		/// F̏ێNX
		class Color
		{
		public:
			//====================================================================================================
			// Static
			//----------------------------------------------------------------------------------------------------

			/// eF1oCg̍ŏl
			static const int mStKMinColorByte = 255;

			/// eF1oCg̍ől
			static const int mStKMaxColorByte = 255;


			/// MEMO:4Ƃ́AԁAA΁Asx4̂ƂłB
			/// eF̐
			static const int mStKColorFactorCount = 4;

			/// sx𔲂eF̐
			static const int mStKColorFactorNoAlphaCount = 3;


			/// ̐ԐF
			static const float mStKInitialRed;

			/// ̗ΐF
			static const float mStKInitialGreen;
			
			/// ̐F
			static const float mStKInitialBlue;
			
			/// ̃
			static const float mStKInitialAlpha;


			/// vZbgF擾
			static Color GetPreset(ColorCode::EColor);


			//====================================================================================================
			// Operation
			//----------------------------------------------------------------------------------------------------

			/// RXgN^
			Color();

			/// RXgN^Be
			Color(const float& kRRed, const float& kRGreen, const float& kRBlue, const float& kRAlpha);

			/// RXgN^Be
			Color(const unsigned& kRARGB);

			/// fXgN^
			~Color();

			/// F𕄍32bitƂĎ擾
			unsigned GetARGB() const;

			/// F𕄍Ȃ32bitƂĐݒ
			void SetARGB(unsigned argb);


			/// YZq[]ł̒l擾\ɂ
			float& operator[] (int index) { return mFactors[index]; }


			/// ԐF擾
			float GetRed() const { return mRed; }

			/// ΐF擾
			float GetGreen() const { return mGreen; }

			/// F擾
			float GetBlue() const { return mBlue; }

			/// 擾
			float GetAlpha() const { return mAlpha; }


			/// e̔z擾
			float* GetArray() { return mFactors; }

			/// e̔z擾
			const float* GetArray() const { return mFactors; }

		private:
			//====================================================================================================
			// PrivateUnion
			//----------------------------------------------------------------------------------------------------

			/// MEMO:̋p͖̂łȂƕϐ錾sȂ΂ȂȂȂ܂B
			/// vf̋p
			union
			{
				/// vf̍\
				struct
				{
					/// 
					float mRed;

					/// 
					float mGreen;

					/// 
					float mBlue;

					/// l
					float mAlpha;
				};

				/// vf̔z
				float mFactors[mStKColorFactorCount];
			};

			
			//====================================================================================================
			// PrivateOperation
			//----------------------------------------------------------------------------------------------------

			/// 0.0f`1.0f0`2551oCgŕ\ł͈͂ɕϊ
			u8 ToByte(const float&) const;

			/// 0`2550.0f`1.0f͈̔͂ŕ\ł͈͂ɕϊ
			float ToFloat(const u8&) const;

			/// 32bit^eF1oCgŎ擾
			void SepareteUnsignedARGB(const unsigned&, u8[mStKColorFactorCount]);
		};

	} // namespace Graphic
} // namespace Blast

#endif // BLAST_GRAPHIC_COLOR_H