#ifndef ANIMATIONCONTROLLER_H
#define ANIMATIONCONTROLLER_H

#include <vector>
#include "Blast/Graphic/AnimationSet.h"

namespace Blast
{
	namespace Graphic
	{
		/// Aj[VRg[[BAnimationSet𕡐ێNXB
		/// DirectXID3DXAnimationControllerQlɂĂ̂ŁAg肪Ɗ炷ɉǂɓݐ؂B
		class AnimationController
		{
		public:
			//====================================================================================================
			// Static
			//----------------------------------------------------------------------------------------------------

			/// őgbN
			static const int stKMaxTrackCount = 2;


			//====================================================================================================
			// Enumerate
			//----------------------------------------------------------------------------------------------------

			/// gbN̖
			enum
			{
				eTRACK_CURRENT = 0,
				eTRACK_BLEND_START = 1,
			};


			//====================================================================================================
			// Struct
			//----------------------------------------------------------------------------------------------------

			/// gbN
			struct STrack
			{
				/// RXgN^
				STrack();

				/// BɏĂAˁB
				/// _
				void Initialize();


				/// Aj[VZbg
				SP<AnimationSet> mPAnimationSet;

				/// uhtOBtrueȂAj[Vuh̑ΏۂɂȂB
				bool mIsAnimationBlend;

				/// x{
				float mSpeedRatio;

				/// oߎԁBϊs̎Zoɒڊւl
				KTime mElapsedTime;

				/// Aj[VSڍsׂɂ鎞
				KTime mShiftTime;

				/// Aj[VڍsJn̎ԁBd݂vZׂɕKv
				KTime mWeightTime;

				/// d݁Bۂɕϊs̎ZoɎgpl
				double mWeight;

				/// [vtOBtrueȂ烋[v
				bool mIsLoop;
			};


			//====================================================================================================
			// Operation
			//----------------------------------------------------------------------------------------------------

			/// RXgN^
			AnimationController();

			/// fXgN^
			~AnimationController();

			/// O[oԂi߂
			void AdvanceTime(double deltaTime);

			/// Aj[VύXB
			/// Aj[VZbg\ߓo^ĂKvB
			void ChangeAnimation(int index, double shiftTime);

			/// Aj[V̑xύXB
			/// l͔{B
			void SetSpeedRatio(float speedRatio);

			/// Aj[VZbg擾
			void GetAnimationSet(int index, SP<AnimationSet>& pOut);
			/// Aj[VZbg𖼑OŎ擾
			void GetAnimationSetByName(const TCHAR* const kPName, SP<AnimationSet> pOut);

			/// Aj[VZbg̐擾
			int GetAnimationSetCount() const;

			/// Aj[VZbgǉ
			void ResisterAnimationSet(SP<AnimationSet> pAnimationSet);
			/// Aj[VZbg폜
			void UnresisterAnimationSet(SP<AnimationSet> pAnimationSet);

			/// ԂZbgB
			void ResetTime();

			/// UNDONE:w肳ꂽgbNɃAj[VKp
			/// Ŏw肳ꂽgbNɃAj[Ṽ~LVOs炵B
			void SetTrackAnimationSet(int trackIndex, SP<AnimationSet> pAnimationSet);

			/// UNDONE:Aj[VRg[[̃Rs[쐬
			void CloneAnimationController(AnimationController** pOutClone);


			/// HACK|[Ys̍XV
			void UpdatePose(
				fbxsdk_2012_2::KFbxXMatrix& rGlobalPosition,
				fbxsdk_2012_2::KFbxMesh* pMesh,
				fbxsdk_2012_2::KTime& pTime,
				fbxsdk_2012_2::KFbxPose* pPose
				);

			/// XLϊs擾
			const SP<fbxsdk_2012_2::KFbxXMatrix> GetClusterDeformations() const { return mPClusterDeformations; }

		private:
			/// O[oԁBԂv邾œʉê͍ƂȂB
			fbxsdk_2012_2::KTime mGlobalTime;

			/// Aj[VZbgQ
			std::vector< SP<AnimationSet> > mPAnimationSets;

			/// gbNzBɂlŃ~LVOsB
			STrack mSTracks[stKMaxTrackCount];
			
			/// XLϊs̔z
			SP<fbxsdk_2012_2::KFbxXMatrix> mPClusterDeformations;
		};
	} // namespace Graphic
} // namespace Blast

#endif // ANIMATIONCONTROLLER_H