#ifndef SINGLETON_H
#define SINGLETON_H

#include "Blast/Utility/Assert.h"
#include "Blast/Utility/SafeDelete.h"


namespace Blast
{
namespace Design
{
	//====================================================================================================
	// Operation
	//----------------------------------------------------------------------------------------------------

	/// pNXVOgɂNX
	template <class T>
	class Singleton {
	public:
		/// CX^X쐬
		static T* CreateInstance()
		{
			// MEMO:d쐬͋֎~܂

			// ASSERT:ɃCX^XȂ玀
			ASSERT_PF(!mInstance, _T("ɃCX^X܂B"));

			// CX^X쐬
			mInstance = new T();

			return mInstance;
		}

		/// CX^Xj
		static void DestroyInstance()
		{
			// MEMO:dj͋֎~܂

			// ASSERT:ɃCX^XȂ玀
			ASSERT_PF(mInstance, _T("CX^X܂B"));

			// CX^X
			SAFE_DELETE(mInstance);
		}

		/// CX^X擾
		static T* GetInstance()
		{
			return mInstance;
		}

	protected:
		/// MEMO:̃NX̂̂̍쐬͋֎~܂Ap̃NXɂ͋邽protectedɂ܂B
		/// RXgN^
		Singleton() { }

		/// MEMO:̃NX̂̂̍쐬͋֎~܂Ap̃NXɂ͋邽protectedɂ܂B
		/// zfXgN^
		virtual ~Singleton() { }

		/// CX^X
		static T* mInstance;

	private:
		/// MEMO:rhiKŃG[o߁A錾݂̂Œ`͂܂B
		/// Rs[RXgN^֎~
		Singleton(const Singleton&);

		/// MEMO:rhiKŃG[o߁A錾݂̂Œ`͂܂B
		/// Zq̏֎~
		void operator= (const Singleton&);
	};

	/// CX^X̎
	template < class T >
	T* Singleton<T>::mInstance = NULL;

} // namespace Design
} // namespace Blast

#endif // SINGLETON_H