#ifndef BLAST_DESIGN_COMSMARTPOINTER_H
#define BLAST_DESIGN_COMSMARTPOINTER_H

namespace Blast
{
	namespace Design
	{
		/// DirectXComnNXɑΉX}[g|C^
		template <class T>
		class ComSmartPointer
		{
		public:
			//====================================================================================================
			// Operation
			//----------------------------------------------------------------------------------------------------

			/// RXgN^
			explicit ComSmartPointer(T* pInterface = NULL, bool isShare = false) :
			mPInterface(NULL)
			{
				// Lȃ|C^LȂ
				if (pInterface && isShare)
				{
					// 
					Release();
				}

				// ێ
				mPInterface = pInterface;
			}

			/// MEMO:IȃRs[T|[g܂B
			/// Rs[RXgN^
			ComSmartPointer(const ComSmartPointer& kRSrc)
			{
				// Lȃ|C^Ȃ
				if (kRSrc.mPInterface)
				{
					// QƐZ
					kRSrc.mPInterface->AddRef();
				}

				// ێ
				mPInterface = kRSrc.mPInterface;
			}

			/// fXgN^
			~ComSmartPointer()
			{
				// 
				Release();
			}

			/// MEMO:ÖٓIȃRs[T|[g܂B
			/// Zq=I[o[[h
			ComSmartPointer& operator= (const ComSmartPointer& kRSrc)
			{
				// Rs[̎QƐZ
				if (kRSrc.mPInterface)
				{
					kRSrc.mPInterface->AddRef();
				}

				// MEMO:IuWFNg쐬ɌĂ΂邽߁AX|C^ێĂ\܂B
				// ̏ꍇAQƐ炳Ȃƃ[N܂B

				// ێĂ|C^̎QƐZ
				Release();

				// Rs[
				mPInterface = kRSrc.mPInterface;

				return (*this);
			}

			/// MEMO:ێĂC^[tF[XύX邱ƂOłB
			/// C^[tF[X֐
			T** ToCreator()
			{
				// MEMO:֐ɓnۂɎQƐẐŁAɎQƐ炵Ă܂B
				// ֐ɓnȂƁAQƐ邾ƂȂA_OǑɂȂĂ܂܂B

				// 
				Release();

				return &mPInterface;
			}

			/// QƐ擾
			s32 GetReferenceCount() const
			{
				// MEMO:QƐ̓JEgAbvJEg_EɎ擾ł邱Ƃ𗘗p܂B

				int refCount = -1;

				// Lȃ|C^ێĂȂ
				if (mPInterface)
				{
					// JEgAbvBɎQƐ擾
					refCount = mPInterface->AddRef();

					// ]ȎQƐZ
					refCount -= 1;

					// JEg_E
					mPInterface->Release();
				}

				return refCount;
			}


			/// dZqI[o[[h
			bool operator== (s32 value)
			{
				// lvȂ
				if (value == static_cast<s32>(mPInterface))
				{
					return true;
				}

				return false;
			}

			/// ]ZqI[o[[h
			bool operator!= (s32 value)
			{
				// lvȂȂ
				if (value != static_cast<s32>(mPInterface))
				{
					return true;
				}

				return false;
			}


			/// boolLXgZqI[o[[h
			operator bool()
			{
				// |C^LȂ
				if (mPInterface)
				{
					return true;
				}
				else
				{
					return false;
				}
			}


			/// A[ZqI[o[[h
			T* operator-> ()
			{
				// ASSERT:Lȃ|C^ŖȂ玀
				ASSERT(mPInterface);

				return mPInterface;
			}

			/// A[ZqI[o[[h
			const T* operator-> () const
			{
				// ASSERT:Lȃ|C^ŖȂ玀
				ASSERT(mPInterface);

				return mPInterface;
			}


			//====================================================================================================
			// Property
			//----------------------------------------------------------------------------------------------------

			/// C^[tF[X|C^ݒ
			void SetInterfacePtr(T* pInterface)
			{
				// Ƀ|C^ێĂȂ
				Release();

				// ێ
				mPInterface = pInterface;
			}


			/// C^[tF[X|C^擾
			const T* GetInterface() const
			{
				return mPInterface;
			}

			/// C^[tF[X|C^擾
			T* GetInterface()
			{
				const ComSmartPointer<T>* kPtr = static_cast<const ComSmartPointer<T>*>(this);

				return const_cast<T*>(kPtr->GetInterface());
			}


			/// C^[tF[X|C^̃|C^擾
			T** GetInterfacePtr()
			{
				return &mPInterface;
			}


			//====================================================================================================
			// Debug
			//----------------------------------------------------------------------------------------------------

			/// o
			void DebugOutput() const
			{
				PFL(_T(""));
				PFL(_T("---------- ComSmartPointer ----------"));

				// Lȃ|C^ێĂȂ
				if (mPInterface)
				{
					// |C^̌^擾
					tstring typeNameStr = Blast::Utility::TypeID::GetTypeNameStr(mPInterface);

					// QƐ擾
					int refCount = GetReferenceCount();

					PFL(_T("^:\"%s\""), typeNameStr.c_str());
					PFL(_T("QƐ\"%d\""), refCount);
				}
				// Lȃ|C^ێĂȂȂ
				else
				{
					PFL(_T("ComSmartPointer͗Lȃ|C^ێĂ܂B"));
				}

				PFL(_T("--------------------------------------------------"));
				PFL(_T(""));
			}

		private:
			/// C^[tF[X|C^
			T* mPInterface;

			
			//====================================================================================================
			// PrivateOperation
			//----------------------------------------------------------------------------------------------------

			// 
			u32 Release()
			{
				// Ƀ|C^ێĂȂ
				if (mPInterface)
				{
					u32 refCount = mPInterface->Release();

					// QƐ0Ȃς݂Ȃ̂NULLɂ
					if (refCount == 0)
					{
						mPInterface = NULL;
					}

					return refCount;
				}

				return -1;
			}
		};

	} // namespace
} // namespace

#endif // BLAST_DESIGN_COMSMARTPOINTER_H