#ifndef BLAST_BASE_MENUENTRYNUMERIC_H
#define BLAST_BASE_MENUENTRYNUMERIC_H

#include "Blast/Base/MenuEntry.h"
#include "Blast/String/Formatting.h"


namespace Blast
{
	namespace Base
	{
		/// fobOj[̐lNX
		template <class T>
		class MenuEntryNumeric : public Blast::Base::MenuEntry
		{
		public:
			//====================================================================================================
			// Static
			//----------------------------------------------------------------------------------------------------

			/// tH[}bgwq̃̕TCY
			static const int mStKFormatStringSize = 32;

			/// Gg[̕`ʒuƂX̑΋̏l
			static const int mStKRelativePositoinX = 150;

			/// Gg[̕`ʒuƂY̑΋̏l
			static const int mStKRelativePositoinY = 0;


			//====================================================================================================
			// Operation
			//----------------------------------------------------------------------------------------------------

			/// RXgN^
			MenuEntryNumeric()
				: mValue(0)
				, mPNumeric(NULL)
				, mRelativeNumericPositionX(mStKRelativePositoinX)
				, mRelativeNumericPositionY(mStKRelativePositoinY)
				, mIsChange(false)
			{
				mStep = 1;
				mLimitOver = 65535;
				mLimitUnder = -65536;
			}

			/// fXgN^
			virtual ~MenuEntryNumeric() { }


			/// 
			virtual void HandleInput(float delta)
			{
				mIsChange = false;

				// I𒆂Ȃ
				if (mIsSelected)
				{
					using namespace Blast::Input;

					// EL[Őlϓ
					InputManager* pIM = Blast::Input::InputManager::GetInstance();
					IKeyboard* pKB = pIM->GetKeyboard();
					const float kInterval = 0.01f;
					const float kDelay = 0.5f; 
					if (pKB->IsDelayRapidDown(Keys::eKEY_RIGHT, kInterval, kDelay))
					{
						StepUp();
						mIsChange = true;
					}
					else if (pKB->IsDelayRapidDown(Keys::eKEY_LEFT, kInterval, kDelay))
					{
						StepDown();
						mIsChange = true;
					}
				}
			}

			/// `
			virtual void Render()
			{
				// NX̕`揈
				MenuEntry::Render();


				// l`
				Blast::Math::Vector3 pos = mPosition;
				pos.mX += static_cast<float>(mRelativeNumericPositionX);
				pos.mY += static_cast<float>(mRelativeNumericPositionY);
				mPTextRenderer->SetPosition(pos);

				// MEMO:NXFݒ肵Ă̂łł͂Ă܂B
				//// Fݒ
				//mPFont->SetColor(mColor);

				TCHAR pText[mStKFormatStringSize];
				ZeroMemory(pText, mStKFormatStringSize);	//< MEMO:z錾sizeofĂA錾̔z񐔂ƈvƂ͌܂B

				tstring formatStr = mFormatting.GetFormatSpecifierStr<T>();
				Blast::String::StringHelper::Format(pText, mStKFormatStringSize, formatStr.c_str(), mValue);

				mPTextRenderer->SetText(pText);
				mPTextRenderer->Render();
			}

			
			//====================================================================================================
			// Property
			//----------------------------------------------------------------------------------------------------

			/// l擾
			T GetValue() const { return mValue; }
			/// lݒ
			void SetValue(T value) { mValue = value; }

			/// l̃|C^擾
			const T* GetNumericPointer() const { return mPNumeric; }
			/// l̃|C^擾
			T* GetNumericPointer() { return mPNumeric; }
			/// l̃|C^ݒ
			void SetNumericPointer(T* pNumeric) { mPNumeric = pNumeric; }

			/// ʂݒ
			void SetStep(T step) { mStep = step; }
			/// lݒ
			void SetLimitOver(T limit) { mLimitOver = limit; }
			/// lݒ
			void SetLimitUnder(T limit) { mLimitUnder = limit; }

			/// lɕύXǂ擾
			bool IsChange() const { return mIsChange; }

		private:
			/// lBNXŕێĂ
			T mValue;

			/// |C^BoChĂȂlݒ肵B
			T* mPNumeric;

			/// l̑Ε`ʒuX
			int mRelativeNumericPositionX;
			/// l̑Ε`ʒuY
			int mRelativeNumericPositionY;

			/// 
			T mStep;
			/// l
			T mLimitOver;
			/// l
			T mLimitUnder;

			/// lɕύXǂ
			bool mIsChange;

			/// tH[}bg
			Blast::String::Formatting mFormatting;


			//====================================================================================================
			// PrivateOperation
			//----------------------------------------------------------------------------------------------------

			/// XebvAbv
			void StepUp()
			{
				// XebvlZ
				mValue += mStep;

				// l𒴂ĂȂ
				if (mLimitOver < mValue)
				{
					mValue = mLimitOver;
				}

				// oChĂ|C^Ȃ甽f
				if (mPNumeric)
				{
					*mPNumeric = mValue;
				}
			}

			/// Xebv_E
			void StepDown()
			{
				// XebvlZ
				mValue -= mStep;
				
				// lĂȂ
				if (mValue < mLimitUnder)
				{
					mValue = mLimitUnder;
				}

				// oChĂ|C^Ȃ甽f
				if (mPNumeric)
				{
					*mPNumeric = mValue;
				}
			}
		};

	} // namespace Base
} // namespace Blast

#endif // BLAST_BASE_MENUENTRYNUMERIC_H