#ifndef BLAST_BASE_DEBUGMENUENTRYLISTSCROLL_H
#define BLAST_BASE_DEBUGMENUENTRYLISTSCROLL_H

#include <vector>
#include "Blast/Base/IMenuEntryList.h"
#include "Blast/Graphic/TextRendererColorTag.h"


namespace Blast
{
	namespace Base
	{
		/// j[ڂ𑩂˂鏈SNX
		class MenuEntryListScroll : public Blast::Base::IMenuEntryList
		{
		public:
			//====================================================================================================
			// Struct
			//----------------------------------------------------------------------------------------------------

			/// vpeB
			struct SProperty
			{
			public:
				//====================================================================================================
				// Static
				//----------------------------------------------------------------------------------------------------

				/// sԂ̏l
				static const int mStKLineSpacingDefault = 2;

				
				//====================================================================================================
				// Operation
				//----------------------------------------------------------------------------------------------------

				/// RXgN^
				SProperty();

				/// 
				void Initialize();


				//====================================================================================================
				// Field
				//----------------------------------------------------------------------------------------------------

				/// O
				tstring mNameStr;
				

				/// IĂCfbNX
				int mSelectedIndex;

				/// IĂCfbNX[v邩ǂ
				bool mIsLoop;


				/// ʒuW
				Blast::Math::Vector3 mPosition;
				
				/// Gg[̊Ԋu
				int mLineSpacing;


				/// Xg̐F
				Blast::Graphic::Color mListNameColor;


				/// xɕ\鍀ڂ̐
				int mVisibleEntryCount;

				/// \Jn鍀ڂ̃CfbNX
				int mVisibleEntryStartIndex;


				/// Xg`悷邩ǂ
				bool mIsRenderGroupName;

			private:
			};


			//====================================================================================================
			// Operation
			//----------------------------------------------------------------------------------------------------

			/// RXgN^
			MenuEntryListScroll();

			/// fXgN^
			virtual ~MenuEntryListScroll();


			/// 
			virtual void HandleInput(float);

			/// XV
			virtual void Update(float);

			/// `
			virtual void Render();


			/// Gg[ǉ
			virtual void AddMenuEntry(SP<Blast::Base::IMenuEntry>);

			/// Gg[O
			virtual void RemoveMenuEntry(SP<Blast::Base::IMenuEntry>);


			/// Gg[擾
			virtual SP<Blast::Base::IMenuEntry> GetMenuEntry(const TCHAR* const kPName) const;

			/// I𒆂̃Gg[擾
			virtual SP<Blast::Base::IMenuEntry> GetSelectedMenuEntry() const;


			/// Gg[̐擾
			virtual int GetEntryCount() const;


			/// O擾
			virtual const TCHAR* const GetName() const;

			/// Oݒ
			virtual void SetName(const TCHAR* const);


			/// IĂCfbNX擾
			virtual int GetSelectedIndex() const;

			/// IĂCfbNXݒ
			virtual void SetSelectedIndex(int);


			/// ʒu擾
			virtual const Blast::Math::Vector3& GetPosition() const;

			/// ʒuݒ
			virtual void SetPosition(const Blast::Math::Vector3&);


			/// O̐F擾
			virtual const Blast::Graphic::Color& GetNameColor() const;

			/// O̐Fݒ
			virtual void SetNameColor(const Blast::Graphic::Color&);


			/// Jݒ
			virtual void SetCamera(const SP<Blast::Graphic::ICamera>);


			/// I[v邩擾
			bool IsLoop() const;

			/// I[v邩ݒ
			void SetIsLoop(bool);


			//====================================================================================================
			// Transfer
			//----------------------------------------------------------------------------------------------------

			/// tHgݒ
			void SetFont(SP<Blast::Graphic::IFont>);


			//====================================================================================================
			// Property
			//----------------------------------------------------------------------------------------------------

			/// vpeB擾
			SProperty& GetPropertyRef()
			{
				return mSProperty;
			}

			/// vpeB擾
			const SProperty& GetPropertyRef() const
			{
				return mSProperty;
			}

		private:
			/// Gg[̔z
			std::vector< SP<IMenuEntry> > mEntries;

			/// eLXg_[
			SP<Blast::Graphic::TextRendererColorTag> mPTextRenderer;


			/// vpeB
			SProperty mSProperty;
		};

	} // namespace Base
} // namespace Blast

#endif // BLAST_BASE_DEBUGMENUENTRYLISTSCROLL_H