#ifndef BLAST_BASE_MENUENTRY_H
#define BLAST_BASE_MENUENTRY_H

#include "Blast/Base/IMenuEntry.h"
#include "Blast/Base/RenderableGameComponent.h"
#include "Blast/Base/SelectableColorComponent.h"
#include "Blast/Graphic/ITextRenderer.h"


namespace Blast
{
	namespace Base
	{
		/// j[Gg[̏SNX
		class MenuEntry :
			public Blast::Base::IMenuEntry,
			public Blast::Base::RenderableGameComponent,
			public Blast::Base::SelectableColorComponent
		{
		public:
			//====================================================================================================
			// Operation
			//----------------------------------------------------------------------------------------------------

			/// RXgN^
			MenuEntry();

			/// fXgN^
			virtual ~MenuEntry();


			/// 
			virtual void HandleInput(float delta);

			/// XV
			virtual void Update(float delta);

			/// `
			virtual void Render();


			/// O擾
			virtual const TCHAR* GetName() const;

			/// Oݒ
			virtual void SetName(const TCHAR*);


			/// eLXg擾
			virtual const TCHAR* GetText() const;

			/// eLXgݒ
			virtual void SetText(const TCHAR*);


			/// ʒu擾
			virtual Blast::Math::Vector3& GetPositionRef();

			/// ʒu擾
			virtual const Blast::Math::Vector3& GetPositionRef() const;

			/// ʒuݒ
			virtual void SetPosition(const Blast::Math::Vector3&);


			/// ʒuX擾
			virtual float GetPositionX() const;

			/// ʒuXݒ
			virtual void SetPositionX(float);


			/// ʒuY擾
			virtual float GetPositionY() const;

			/// ʒuYݒ
			virtual void SetPositionY(float);
			
			
			/// ʒuZ擾
			virtual float GetPositionZ() const;

			/// ʒuZݒ
			virtual void SetPositionZ(float);


			/// ]擾
			virtual Blast::Math::Vector3& GetRotationRef();

			/// ]擾
			virtual const Blast::Math::Vector3& GetRotationRef() const;

			/// ]ݒ
			virtual void SetRotation(const Blast::Math::Vector3&);


			/// ]X擾
			virtual float GetRotationX() const;

			/// ]Xݒ
			virtual void SetRotationX(float);


			/// ]Y擾
			virtual float GetRotationY() const;

			/// ]Yݒ
			virtual void SetRotationY(float);
			
			
			/// ]Z擾
			virtual float GetRotationZ() const;

			/// ]Zݒ
			virtual void SetRotationZ(float);


			/// F擾
			virtual Blast::Graphic::Color& GetColorRef();

			/// F擾
			virtual const Blast::Graphic::Color& GetColorRef() const;

			/// Fݒ
			virtual void SetColor(const Blast::Graphic::Color&);


			/// tHg擾
			virtual SP<Blast::Graphic::IFont> GetFont();

			/// tHgݒ
			virtual void SetFont(SP<Blast::Graphic::IFont>);


			/// 擾
			virtual float GetWidth() const;

			/// c擾
			virtual float GetHeight() const;


			/// Jݒ
			virtual void SetCamera(const SP<Blast::Graphic::ICamera>);

		protected:
			/// O
			tstring mNameStr;

			/// eLXg
			tstring mTextStr;


			/// ʒu
			Blast::Math::Vector3 mPosition;

			/// ]
			Blast::Math::Vector3 mRotation;


			/// F
			Blast::Graphic::Color mColor;


			/// eLXg_\
			SP<Blast::Graphic::ITextRenderer> mPTextRenderer;
		};

	} // namespace Base
} // namespace Blast

#endif // BLAST_BASE_MENUENTRY_H