#ifndef BLAST_BASE_IMENUENTRYLIST
#define BLAST_BASE_IMENUENTRYLIST

#include "Blast/Base/IMenuEntry.h"


namespace Blast
{
	namespace Base
	{
		/// Gg[̃Xg̃C^[tF[X
		class IMenuEntryList
		{
		public:
			//====================================================================================================
			// Operation
			//----------------------------------------------------------------------------------------------------

			/// fXgN^
			virtual ~IMenuEntryList() { }


			/// 
			virtual void HandleInput(float) = 0;

			/// XV
			virtual void Update(float) = 0;

			/// `
			virtual void Render() = 0;


			/// Gg[ǉ
			virtual void AddMenuEntry(SP<Blast::Base::IMenuEntry>) = 0;

			/// Gg[O
			virtual void RemoveMenuEntry(SP<Blast::Base::IMenuEntry>) = 0;


			/// Gg[擾
			virtual SP<Blast::Base::IMenuEntry> GetMenuEntry(const TCHAR* const kPName) const = 0;

			/// I𒆂̃Gg[擾
			virtual SP<Blast::Base::IMenuEntry> GetSelectedMenuEntry() const = 0;


			/// Gg[̐擾
			virtual int GetEntryCount() const = 0;


			/// O擾
			virtual const TCHAR* const GetName() const = 0;

			/// Oݒ
			virtual void SetName(const TCHAR* const) = 0;


			/// IĂCfbNX擾
			virtual int GetSelectedIndex() const = 0;

			/// IĂCfbNXݒ
			virtual void SetSelectedIndex(int) = 0;


			/// ʒu擾
			virtual const Blast::Math::Vector3& GetPosition() const = 0;

			/// ʒuݒ
			virtual void SetPosition(const Blast::Math::Vector3&) = 0;


			/// O̐F擾
			virtual const Blast::Graphic::Color& GetNameColor() const = 0;

			/// O̐Fݒ
			virtual void SetNameColor(const Blast::Graphic::Color&) = 0;


			/// Jݒ
			virtual void SetCamera(const SP<Blast::Graphic::ICamera>) = 0;

		private:
		};
	} // Base
} // namespace Blast

#endif // BLAST_BASE_IMENUENTRYLIST