#ifndef BLAST_BASE_IMENUENTRY_H
#define BLAST_BASE_IMENUENTRY_H

#include "Blast/Graphic/IFont.h"
#include "Blast/Graphic/ICamera.h"


namespace Blast
{
	namespace Base
	{
		/// j[̍ڂ̏SC^[tF[X
		class IMenuEntry
		{
		public:
			//====================================================================================================
			// Operation
			//----------------------------------------------------------------------------------------------------

			/// fXgN^
			virtual ~IMenuEntry() { }


			/// 
			virtual void HandleInput(float delta) = 0;

			/// XV
			virtual void Update(float delta) = 0;

			/// `
			virtual void Render() = 0;


			/// O擾
			virtual const TCHAR* GetName() const = 0;

			/// Oݒ
			virtual void SetName(const TCHAR*) = 0;


			/// eLXg擾
			virtual const TCHAR* GetText() const = 0;

			/// eLXgݒ
			virtual void SetText(const TCHAR*) = 0;


			/// ʒu擾
			virtual Blast::Math::Vector3& GetPositionRef() = 0;

			/// ʒu擾
			virtual const Blast::Math::Vector3& GetPositionRef() const = 0;

			/// ʒuݒ
			virtual void SetPosition(const Blast::Math::Vector3&) = 0;


			/// ʒuX擾
			virtual float GetPositionX() const = 0;

			/// ʒuXݒ
			virtual void SetPositionX(float) = 0;


			/// ʒuY擾
			virtual float GetPositionY() const = 0;

			/// ʒuYݒ
			virtual void SetPositionY(float) = 0;
			
			
			/// ʒuZ擾
			virtual float GetPositionZ() const = 0;

			/// ʒuZݒ
			virtual void SetPositionZ(float) = 0;


			/// ]擾
			virtual Blast::Math::Vector3& GetRotationRef() = 0;

			/// ]擾
			virtual const Blast::Math::Vector3& GetRotationRef() const = 0;

			/// ]ݒ
			virtual void SetRotation(const Blast::Math::Vector3&) = 0;


			/// ]X擾
			virtual float GetRotationX() const = 0;

			/// ]Xݒ
			virtual void SetRotationX(float) = 0;


			/// ]Y擾
			virtual float GetRotationY() const = 0;

			/// ]Yݒ
			virtual void SetRotationY(float) = 0;
			
			
			/// ]Z擾
			virtual float GetRotationZ() const = 0;

			/// ]Zݒ
			virtual void SetRotationZ(float) = 0;


			/// F擾
			virtual Blast::Graphic::Color& GetColorRef() = 0;

			/// F擾
			virtual const Blast::Graphic::Color& GetColorRef() const = 0;

			/// Fݒ
			virtual void SetColor(const Blast::Graphic::Color&) = 0;


			/// tHg擾
			virtual SP<Blast::Graphic::IFont> GetFont() = 0;

			/// tHgݒ
			virtual void SetFont(SP<Blast::Graphic::IFont>) = 0;


			/// 擾
			virtual float GetWidth() const = 0;

			/// c擾
			virtual float GetHeight() const = 0;


			/// Jݒ
			virtual void SetCamera(const SP<Blast::Graphic::ICamera>) = 0;
		};

	} // namespace Base
} // namespace Blast

#endif // BLAST_BASE_IMENUENTRY_H