#ifndef BLAST_BASE_GAMECOMPONENTCONTAINER_H
#define BLAST_BASE_GAMECOMPONENTCONTAINER_H

#include <list>
#include "Blast/Base/IGameComponent.h"
#include "Blast/Base/IUpdatable.h"
#include "Blast/Base/IRenderable.h"

namespace Blast
{
	namespace Base
	{
		/// Q[R|[lg𑩂˂NX
		class GameComponentContainer
		{
		public:
			//====================================================================================================
			// Alias
			//----------------------------------------------------------------------------------------------------

			/// Q[R|[lg̃Xǧ^
			typedef std::list< SP<IGameComponent> > GameComponentList;

			/// XV\C^[tF[X̃Xǧ^
			typedef std::list< SP<IUpdatable> > UpdatableList;

			/// `\C^[tF[X̃Xǧ^
			typedef std::list< SP<IRenderable> > RenderableList;


			
			//====================================================================================================
			// Predicate
			//----------------------------------------------------------------------------------------------------

			/// XVԏ̃vfBP[g
			struct AscendingUpdateOrder
			{
				bool operator() (const SP<IUpdatable>& kRA, const SP<IUpdatable>& kRB) const;
			};

			/// `揇ԏ̃vfBP[g
			struct AscendingRenderOrder
			{
				bool operator() (const SP<IRenderable>& kRA, const SP<IRenderable>& kRB) const;
			};


			//====================================================================================================
			// Operation
			//----------------------------------------------------------------------------------------------------

			/// RXgN^
			GameComponentContainer();

			/// fXgN^
			virtual ~GameComponentContainer();

			/// XV
			void Update(float);

			/// `
			void Render();


			/// Q[R|[lgǉ
			void Add(SP<IGameComponent>);

			/// Q[R|[lgǉ
			void Add(SP<IGameComponent>, SP<GameComponentContainer>);

			/// Q[R|[lgO
			void Remove(SP<IGameComponent>);

			/// Q[R|[lgNA
			void Clear();


			/// MEMO:XVύXꂽۂɊOĂяoĂ܂B
			/// XVXgXV
			void UpdateUpdatableList();

			/// MEMO:`揇ύXꂽۂɊOĂяoĂ܂B
			/// `惊XgXV
			void UpdateRenderableList();

		private:
			/// Q[R|[lg̍XVXg
			UpdatableList mUpdatableList;

			/// Q[R|[lg̕`惊Xg
			RenderableList mRenderableList;
		};

	} // namespace Base
} // namespace Blast


#endif // BLAST_BASE_GAMECOMPONENTCONTAINER_H