#ifndef BLAST_BASE_FPSCOUNTER_H
#define BLAST_BASE_FPSCOUNTER_H

#include <list>


namespace Blast
{
	namespace Base
	{
		/// FPSvNX
		class FPSCounter
		{
		public:
			//====================================================================================================
			// Static
			//----------------------------------------------------------------------------------------------------

			/// ̃TvO
			static const int mStKSamplingCount = 10000;


			//====================================================================================================
			// Alias
			//----------------------------------------------------------------------------------------------------

			/// Ԃ̔ž^
			typedef std::list<double> MillDeltas;


			//====================================================================================================
			// Operation
			//----------------------------------------------------------------------------------------------------

			/// RXgN^
			FPSCounter(int samplingCount = mStKSamplingCount);

			/// fXgN^
			~FPSCounter();

			/// MEMO:擾邽тɁAŎZo܂B
			/// FPS擾
			double GetFPS();

			/// TvOݒ
			void SetSamplingCount(int);

		private:
			/// ԃXg
			MillDeltas mMillDeltaList;

			/// ̑
			double mTotalMillDelta;

			/// MEMO:Pʂ̓~błB
			/// O擾
			u64 mOldTime;

			/// NbNg
			double mFrequency;

			/// TvO
			int mSamplingCount;


			//====================================================================================================
			// PrivateOperation
			//----------------------------------------------------------------------------------------------------

			/// NbNg擾
			double GetFrequency() const;

			/// ݂̎Ԃ擾
			u64 GetCurrentTime() const;

			/// Ot[Ƃ̍Ԃ擾
			double GetMillDeltaTime();
			
			/// f^XgXV
			double UpdateDeltaList(double delta);
		};

	} // namespace Base
} // namespace Blast

#endif // BLAST_BASE_FPSCOUNTER_H