#ifndef BLAST_APPLICATION_WINDOWBASE_H
#define BLAST_APPLICATION_WINDOWBASE_H

#include <windows.h>
#include <tchar.h>


namespace Blast
{
namespace Application
{
	/// Windows̊ՂƂȂNX
	class WindowBase
	{
	public:
		//====================================================================================================
		// Struct
		//----------------------------------------------------------------------------------------------------

		/// EBhȄ
		struct SProperty
		{
			//====================================================================================================
			// Static
			//----------------------------------------------------------------------------------------------------

			/// NX̃obt@TCY
			static const int mStKClassNameBufferSize = 64;

			/// EBhẼobt@TCY
			static const int mStKWindowNameBufferSize = 64;


			//====================================================================================================
			// Operation
			//----------------------------------------------------------------------------------------------------

			/// 
			virtual void Initialize(HINSTANCE, const TCHAR kClassName[]);


			// <<<<< Field >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>

			/// NX
			TCHAR mClassName[mStKClassNameBufferSize];

			/// EBhE
			TCHAR mWindowName[mStKWindowNameBufferSize];

			/// EBhE̎
			DWORD mStyle;

			/// EBhEXWʒu
			int mPositionX;

			/// EBhEYWʒu
			int mPositionY;

			/// EBhẺ
			int mWidth;

			/// EBhȄc
			int mHeight;

			/// eEBhE
			HWND mParentWindowHandle;

			/// j[o[
			HMENU mMenuBarHandle;

			/// CX^Xnh
			HINSTANCE mHInstance;

			/// p[^[
			LPVOID mParameter;
		};


		//====================================================================================================
		// Operation
		//----------------------------------------------------------------------------------------------------

		/// RXgN^
		WindowBase();

		/// fXgN^
		virtual ~WindowBase();

		/// 쐬
		bool Create(const SProperty&);

		/// vV[W
		virtual LRESULT WindowProcedural(HWND, UINT message, WPARAM, LPARAM);

		
		//====================================================================================================
		// Property
		//----------------------------------------------------------------------------------------------------

		/// EBhEnh|C^Ŏ擾
		HWND* GetWindowHandle()
		{
			return &mWindowHandle;
		}

		/// EBhEnhQƂŎ擾
		HWND& GetWindowHandleRef()
		{
			return mWindowHandle;
		}

		/// EBhEvpeB|C^Ŏ擾
		const SProperty* GetWindowProperty() const
		{
			return &mSProperty;
		}

		/// EBhEvpeBQƂŎ擾
		const SProperty& GetWindowPropertyRef() const
		{
			return mSProperty;
		}

	private:
		/// EBhEnh
		HWND mWindowHandle;

		/// EBhẼvpeB
		SProperty mSProperty;
	};

} // namespace Application
} // namespace Blast

#endif // BLAST_APPLICATION_WINDOWBASE_H