#ifndef BLAST_APPLICATION_APPLICATIONBASE_H
#define BLAST_APPLICATION_APPLICATIONBASE_H

#include <windows.h>
#include <vector>
#include "Blast/Application/WindowBase.h"
#include "Blast/Design/SmartPointer.h"


namespace Blast
{
namespace Application
{
	/// WindowsAvP[V̊ՂƂȂNX
	class ApplicationBase
	{
	public:
		//====================================================================================================
		// Alias
		//----------------------------------------------------------------------------------------------------

		// EBhEx[X̃X}[g|C^
		typedef SP< Blast::Application::WindowBase > SPWindowBase;

		// X}[g|C^ɂEBhEx[X̔z
		typedef std::vector< SPWindowBase > WindowBases;


		//====================================================================================================
		// Static
		//----------------------------------------------------------------------------------------------------

		/// NX̃obt@TCY
		static const int mStKClassNameBufferSize = 32;

		/// vV[W
		static LRESULT CALLBACK StWindowProcedural(HWND, UINT message, WPARAM, LPARAM);


		//====================================================================================================
		// Operation
		//----------------------------------------------------------------------------------------------------

		/// RXgN^
		ApplicationBase();

		/// fXgN^
		virtual ~ApplicationBase();

		/// AvP[V̎sJn
		int Run(HINSTANCE, int cmdShow);


		//====================================================================================================
		// Property
		//----------------------------------------------------------------------------------------------------

		/// EBhEx[XQ|C^Ŏ擾
		WindowBases* GetWindowBases()
		{
			return &mWindowBases;
		}

		/// EBhEx[XQQƂŎ擾
		WindowBases& GetWindowBasesRef()
		{
			return mWindowBases;
		}

		/// CX^Xnh擾
		HINSTANCE GetHInstance() const
		{
			return mHInstance;
		}

		/// R}h擾
		int GetCommandShow() const
		{
			return mCommandShow;
		}

		/// EBhENX\̂ݒ
		void SetWindowClassEx(const WNDCLASSEX& rWndClassEx)
		{
			mWindowClassEx = rWndClassEx;
		}

		/// EBhENX\̂QƂŎ擾
		const WNDCLASSEX& GetWindowClassEx() const
		{
			return mWindowClassEx;
		}

	protected:
		//====================================================================================================
		// Operation
		//----------------------------------------------------------------------------------------------------

		/// EBhE̓o^
		virtual bool RegisterWindowClass();

		// MEMO:CreateWindowł̓}NƔ邽߁AMainł܂

		/// EBhE̍쐬
		virtual bool CreateMainWindow();

		/// EBhE̕\
		virtual bool ShowMainWindow();

		/// 
		virtual bool Initialize();

		/// bZ[W[v̎s
		virtual int Loop();

		/// I
		virtual void Release();


		/// EBhETCYNCAgTCYɕύX
		virtual void ChangeToCliantSize(HWND&, int width, int height);


		//====================================================================================================
		// Static
		//----------------------------------------------------------------------------------------------------

		/// EBhEx[XQ
		WindowBases mWindowBases;

	private:
		/// CX^Xnh
		HINSTANCE mHInstance;

		/// R}h
		int mCommandShow;

		/// EBhENX\
		WNDCLASSEX mWindowClassEx;
	};

} // namespace Application
} // namespace Blast


#endif // BLAST_APPLICATION_APPLICATIONBASE_H