﻿Imports System.IO

Namespace Book

    Public Class BookManager
        Const BOOK_FILE_NAME = "reversi.book"
        Private Shared Function GetFullFileName() As String
            Return IOUtil.GetExePath & "/" & BOOK_FILE_NAME
        End Function

        Private _root As Node = Nothing

        Public Sub New()
            _root = New Node
            _root.Point = New Point("f5")
            Using sw As StreamReader = New StreamReader(GetFullFileName)
                While Not sw.EndOfStream
                    Dim codesline = sw.ReadLine
                    Dim book As New List(Of Point)
                    For i As Integer = 0 To codesline.Length - 2 Step 2
                        Dim p As Point = New Point(codesline.Substring(i, 2))
                        book.Add(p)
                    Next
                    Add(book)
                End While
            End Using

        End Sub

        Public Sub Add(ByVal book As IList(Of Point))
            Dim node As Node = _root
            For i As Integer = 1 To book.Count - 1
                Dim p As Point = book(i)
                If node.Child Is Nothing Then
                    node.Child = New Node
                    node = node.Child
                    node.Point = p
                Else
                    node = node.Child
                    While (True)
                        If node.Point = p Then
                            Exit While
                        End If

                        If node.Sibling Is Nothing Then
                            node.Sibling = New Node
                            node = node.Sibling
                            node.Point = p
                            Exit While
                        End If
                        node = node.Sibling
                    End While
                End If
            Next

        End Sub


        Public Function Find(ByVal board As Board) As IList(Of Point)
            Dim node As Node = _root
            Dim history As IList(Of Point) = board.History

            If history.Count = 0 Then
                Return board.MovablePostions
            End If

            Dim transformer As New CoordinatesTransFormer(history(0))
            Dim normalizedHistory As New List(Of Point)
            For Each p As Point In history
                Dim normalizedPoint As Point = transformer.Normalize(p)
                normalizedHistory.Add(normalizedPoint)
            Next

            For i As Integer = 1 To normalizedHistory.Count - 1
                Dim p As Point = normalizedHistory(i)
                node = node.Child
                While node IsNot Nothing
                    If node.Point = p Then
                        Exit While
                    End If
                    node = node.Sibling
                End While
                If node Is Nothing Then
                    '定石から外れている。
                    Return board.MovablePostions
                End If
            Next
            If node.Child Is Nothing Then
                '履歴は定石の終わりと一致
                Return board.MovablePostions
            End If

            Dim nextMove As Point = GetNextMove(node)
            nextMove = transformer.DeNormalize(nextMove)
            Dim points As New List(Of Point)
            points.Add(nextMove)
            Return points
        End Function

        Public Function GetNextMove(ByVal node As Node) As Point
            Dim candidates As New List(Of Point)
            Dim p As Node = node.Child
            While p IsNot Nothing
                candidates.Add(p.Point)
                p = p.Sibling
            End While

            Dim index As Integer = (New Random).Next Mod candidates.Count
            Return candidates(index)

        End Function


        ''' <summary>
        ''' 定石を追加する。
        ''' </summary>
        ''' <param name="codesLine">f5から始まる定石文字列</param>
        ''' <remarks></remarks>
        Public Shared Sub WriteLine(ByVal codesLine As String)
            Try
                '書込むファイルを指定する
                '（2番目の引数をtrueにすることで既存ファイルに追記する）
                Dim sw As StreamWriter = New StreamWriter _
                 (GetFullFileName(), True, System.Text.Encoding.Default)
                'ファイルに書込む
                sw.WriteLine(codesLine)
                sw.Flush()
                sw.Close()
            Catch ex As Exception
                Console.WriteLine("ファイルに書込めません:")
                Console.WriteLine(ex.Message)
            End Try
        End Sub

    End Class

End Namespace

