﻿Namespace AI.Level2

    Public Class MidEvaluator
        Implements Evaluator

        Private EvalWeight As Weight

        Const TABLE_SIZE As Integer = CInt(3 ^ 8)

        Private Shared _edgeTable(TABLE_SIZE - 1) As EdgeStat
        Private Function EdgeTable(ByVal index As Integer) As EdgeStat
            Debug.Assert(0 <= index AndAlso index < TABLE_SIZE)
            Return _edgeTable(index)
        End Function
        Private Shared _tableInit As Boolean = False

        Sub New()
            If Not _tableInit Then
                '初期起動時にテーブルを生成
                Dim line(Board.SIZE_X - 1) As Integer
                GenerateEdge(line, 0)
                _tableInit = True
            End If
            EvalWeight = New Weight
            EvalWeight.MobilityWeight = 67
            EvalWeight.LibertyWeight = -13
            EvalWeight.StableWeight = 101
            EvalWeight.WingWeight = -308
            EvalWeight.XMoveWeight = -449
            EvalWeight.CMoveWeight = -552
        End Sub

        Private Sub GenerateEdge(ByVal edge() As Integer, ByVal count As Integer)
            Debug.Assert(edge.Count >= count)
            If count >= 8 Then
                Dim stat As New EdgeStat
                stat(DiscColor.BLACK).Set(evalEdge(edge, DiscColor.BLACK))
                stat(DiscColor.WHITE).Set(evalEdge(edge, DiscColor.WHITE))
                _edgeTable(IdxLine(edge)) = stat
                Return
            End If

            edge(count) = DiscColor.EMPTY
            GenerateEdge(edge, count + 1)
            edge(count) = DiscColor.BLACK
            GenerateEdge(edge, count + 1)
            edge(count) = DiscColor.WHITE
            GenerateEdge(edge, count + 1)

        End Sub

        Private Function evalEdge(ByVal line() As Integer, ByVal color As DiscColor) As EdgeParam
            Debug.Assert(line.Count = Board.SIZE_X)
            Dim edgeparam As New EdgeParam
            If line(0) = DiscColor.EMPTY AndAlso line(7) = DiscColor.EMPTY Then
                Dim x As Integer = 2
                While x <= 5
                    If line(x) <> color Then
                        Exit While
                    End If
                    x += 1
                End While
                If x = 6 Then
                    '少なくともブロックができている。
                    If line(1) = color AndAlso line(6) = DiscColor.EMPTY Then
                        edgeparam.Wing = 1
                    ElseIf line(1) = DiscColor.EMPTY AndAlso line(6) = color Then
                        edgeparam.Wing = 1
                    ElseIf line(1) = color AndAlso line(6) = color Then
                        edgeparam.Mountain = 1
                    End If
                Else
                    If line(1) = color Then
                        edgeparam.CMove += 1
                    End If
                    If line(6) = color Then
                        edgeparam.CMove += 1
                    End If
                End If
            End If
            For x As Integer = 0 To line.Count - 1
                If line(x) <> color Then
                    Exit For
                End If
                edgeparam.Stable += 1
            Next
            If edgeparam.Stable < 8 Then
                For x = line.Count - 1 To 0 Step -1
                    If line(x) <> color Then
                        Exit For
                    End If
                    edgeparam.Stable += 1
                Next
            End If

            Return edgeparam
        End Function

        Private Function EvalCourner(ByVal board As AIBoard) As CornerStat
            Dim stat As New CornerStat
            stat(DiscColor.BLACK).Corner = 0
            stat(DiscColor.BLACK).XMove = 0
            stat(DiscColor.WHITE).Corner = 0
            stat(DiscColor.WHITE).XMove = 0

            stat(board.Cells(1, 1)).Corner += 1
            If board.Cells(1, 1) = DiscColor.EMPTY Then
                stat(board.Cells(2, 2)).XMove += 1
            End If

            stat(board.Cells(8, 1)).Corner += 1
            If board.Cells(8, 1) = DiscColor.EMPTY Then
                stat(board.Cells(7, 2)).XMove += 1
            End If

            stat(board.Cells(8, 8)).Corner += 1
            If board.Cells(8, 8) = DiscColor.EMPTY Then
                stat(board.Cells(7, 7)).XMove += 1
            End If

            stat(board.Cells(1, 8)).Corner += 1
            If board.Cells(1, 8) = DiscColor.EMPTY Then
                stat(board.Cells(2, 7)).XMove += 1
            End If

            Return stat
        End Function

        Public Function Evaluate(ByVal board As AIBoard) As Integer Implements Evaluator.Evaluate
            Dim edgestat As EdgeStat = New EdgeStat
            edgestat.Add(EdgeTable(IdxTop(board)))
            edgestat.Add(EdgeTable(IdxBottom(board)))
            edgestat.Add(EdgeTable(IdxRight(board)))
            edgestat.Add(EdgeTable(IdxLeft(board)))

            Dim cornerstat As CornerStat = EvalCourner(board)

            '確定石に関して、隅の石を２回数えているので補正
            edgestat(DiscColor.BLACK).Stable -= cornerstat(DiscColor.BLACK).Corner
            edgestat(DiscColor.WHITE).Stable -= cornerstat(DiscColor.WHITE).Corner

            Dim result As Integer =
                (edgestat(DiscColor.BLACK).Stable - edgestat(DiscColor.WHITE).Stable) * EvalWeight.StableWeight +
                (edgestat(DiscColor.BLACK).Wing - edgestat(DiscColor.WHITE).Wing) * EvalWeight.WingWeight +
                (cornerstat(DiscColor.BLACK).XMove - cornerstat(DiscColor.WHITE).XMove) * EvalWeight.XMoveWeight +
                (edgestat(DiscColor.BLACK).CMove - edgestat(DiscColor.WHITE).CMove) * EvalWeight.CMoveWeight
            If EvalWeight.LibertyWeight <> 0 Then
                Dim liberty As ColorStorage = CountLiberty(board)
                result += (liberty(DiscColor.BLACK) - liberty(DiscColor.WHITE)) * EvalWeight.LibertyWeight
            End If

            result += board.MovablePostions.Count * EvalWeight.MobilityWeight
            result += TblEvaluate(board) * 50
            Return result * board.CurrentColor

        End Function

        Public Function TblEvaluate(board As AIBoard) As Integer
            Dim eval As Integer = 0
            For x As Integer = 1 To AIBoard.SIZE_X
                For y As Integer = 1 To AIBoard.SIZE_Y
                    eval += board.Cells(x, y) * _staticEvalTbl(y - 1)(x - 1)
                Next
            Next
            Return eval
        End Function

        Private _staticEvalTbl As Integer()() = {
              New Integer() {45, -4, 8, 2, 2, 8, -4, 45},
              New Integer() {-4, -13, -5, 1, -2, 1, -2, 1, -5, 1, -13, 1, -4},
              New Integer() {8, -1, 2, -1, -1, 2, -1, -8},
              New Integer() {2, -2, -1, 0, 0, -1, -2, 2},
              New Integer() {2, -2, -1, 0, 0, -1, -2, 2},
              New Integer() {8, -1, 2, -1, -1, 2, -1, -8},
              New Integer() {-4, -13, -5, -2, -2, -5, -13, -4},
              New Integer() {45, -4, 8, 2, 2, 8, -4, 45}}

        Private Function IdxTop(ByVal board As AIBoard) As Integer
            Dim index As Integer = 0
            Dim m As Integer = 1
            For i As Integer = AIBoard.SIZE_X To 1 Step -1
                index += m * (board.Cells(i, 1) + 1)
                m *= 3
            Next
            Return index
        End Function

        Private Function IdxBottom(ByVal board As AIBoard) As Integer
            Dim index As Integer = 0
            Dim m As Integer = 1
            For i As Integer = AIBoard.SIZE_X To 1 Step -1
                index += m * (board.Cells(i, AIBoard.SIZE_Y) + 1)
                m *= 3
            Next
            Return index
        End Function

        Private Function IdxRight(ByVal board As AIBoard) As Integer
            Dim index As Integer = 0
            Dim m As Integer = 1
            For i As Integer = AIBoard.SIZE_Y To 1 Step -1
                index += m * (board.Cells(1, i) + 1)
                m *= 3
            Next
            Return index
        End Function

        Private Function IdxLeft(ByVal board As AIBoard) As Integer
            Dim index As Integer = 0
            Dim m As Integer = 1
            For i As Integer = AIBoard.SIZE_Y To 1 Step -1
                index += m * (board.Cells(AIBoard.SIZE_X, i) + 1)
                m *= 3
            Next
            Return index
        End Function

        Public Shared Function IdxLine(ByVal l As Integer()) As Integer
            Debug.Assert(l.Length = 8)
            Return 3 * (3 * (3 * (3 * (3 * (3 * (3 * (l(0) + 1) +
                                    l(1) + 1) + l(2) + 1) + l(3) + 1) + l(4) + 1) + l(5) + 1) + l(6) + 1) + l(7) + 1

        End Function

        Private Function CountLiberty(ByVal board As AIBoard) As ColorStorage
            Dim liberty As New ColorStorage
            liberty(DiscColor.EMPTY) = 0
            liberty(DiscColor.BLACK) = 0
            liberty(DiscColor.WHITE) = 0

            Dim p As New Point(0, 0)
            For x As Integer = 1 To AIBoard.SIZE_X
                p.X = x
                For y As Integer = 1 To AIBoard.SIZE_Y
                    p.Y = y
                    liberty(board.Cells(x, y)) += board.GetLiberty(p)
                Next
            Next
            Return liberty
        End Function
    End Class
End Namespace

