﻿Imports ReversiGame

Imports Microsoft.VisualStudio.TestTools.UnitTesting

Imports ReversiGame.AI

Namespace AI




    '''<summary>
    '''AIBoardTest のテスト クラスです。すべての
    '''AIBoardTest 単体テストをここに含めます
    '''</summary>
    <TestClass()> _
    Public Class AIBoardTest


        Private testContextInstance As TestContext

        '''<summary>
        '''現在のテストの実行についての情報および機能を
        '''提供するテスト コンテキストを取得または設定します。
        '''</summary>
        Public Property TestContext() As TestContext
            Get
                Return testContextInstance
            End Get
            Set(value As TestContext)
                testContextInstance = value
            End Set
        End Property

#Region "追加のテスト属性"
        '
        'テストを作成するときに、次の追加属性を使用することができます:
        '
        'クラスの最初のテストを実行する前にコードを実行するには、ClassInitialize を使用
        '<ClassInitialize()>  _
        'Public Shared Sub MyClassInitialize(ByVal testContext As TestContext)
        'End Sub
        '
        'クラスのすべてのテストを実行した後にコードを実行するには、ClassCleanup を使用
        '<ClassCleanup()>  _
        'Public Shared Sub MyClassCleanup()
        'End Sub
        '
        '各テストを実行する前にコードを実行するには、TestInitialize を使用
        '<TestInitialize()>  _
        'Public Sub MyTestInitialize()
        'End Sub
        '
        '各テストを実行した後にコードを実行するには、TestCleanup を使用
        '<TestCleanup()>  _
        'Public Sub MyTestCleanup()
        'End Sub
        '
#End Region


        '''<summary>
        '''GetLiberty のテスト
        '''</summary>
        <TestMethod()> _
        Public Sub GetLibertyTest()
            Dim target As AIBoard = New AIBoard()
            Assert.AreEqual(5, target.GetLiberty(New Point(4, 4)))
            Assert.AreEqual(7, target.GetLiberty(New Point(3, 3)))
            Assert.AreEqual(8, target.GetLiberty(New Point(2, 2)))
            Assert.AreEqual(3, target.GetLiberty(New Point(1, 1)))
            Assert.AreEqual(5, target.GetLiberty(New Point(1, 2)))
        End Sub

        <TestMethod()> _
        Public Sub MoveTest()
            Dim target As AIBoard = New AIBoard()
            target.Move(New Point(3, 4))
            Assert.AreEqual(4, target.GetLiberty(New Point(4, 4)))
            Assert.AreEqual(6, target.GetLiberty(New Point(3, 3)))
            Assert.AreEqual(8, target.GetLiberty(New Point(2, 2)))
            Assert.AreEqual(3, target.GetLiberty(New Point(1, 1)))
            Assert.AreEqual(5, target.GetLiberty(New Point(1, 2)))
        End Sub
    End Class

End Namespace