// Programming 2D Games
// Copyright (c) 2011 by: 
// Charles Kelly
// Chapter 9 dashboardDemo.cpp v1.0

#include "dashboardDemo.h"

//=============================================================================
// Constructor
//=============================================================================
DashboardDemo::DashboardDemo()
{
    buttonCount = 0;
}

//=============================================================================
// Destructor
//=============================================================================
DashboardDemo::~DashboardDemo()
{
    releaseAll();				// call deviceLost() for every graphics item
}


//=============================================================================
// initializes the game
// Throws GameError on error
//=============================================================================
void DashboardDemo::initialize(HWND hwnd)
{
    Game::initialize(hwnd); // throws GameError

    // gauge textures
    if (!dashboardTextures.initialize(graphics, DASHBOARD_TEXTURES))
        throw(GameError(gameErrorNS::FATAL_ERROR, "Error initializing dashboard textures"));

    sevenSegment.initialize(graphics, &dashboardTextures, DIGITS_X, DIGITS_Y, 0.5f, 8, graphicsNS::RED);

    pushButton.initialize(graphics, &dashboardTextures, input, hwnd, PUSH_X, PUSH_Y, 0.5f, true);
}


//=============================================================================
// Reset the game to begin play and after a score
//=============================================================================
void DashboardDemo::reset()
{
    return;
}

//=============================================================================
// move all game items
// frameTime is used to regulate the speed of movement
//=============================================================================
void DashboardDemo::update()
{
    pushButton.update(frameTime);
    if(pushButton.getSwitchOn())    // if push button switch on
        buttonCount++;
    sevenSegment.set(buttonCount);          // display fps in seven segment
}

//=============================================================================
// render game items and do end of round logic
//=============================================================================
void DashboardDemo::render()
{
    graphics->spriteBegin();                // begin drawing sprites
    sevenSegment.draw(graphicsNS::FILTER);
    pushButton.draw();
    graphics->spriteEnd();                  // end drawing sprites
}

//=============================================================================
// The graphics device was lost.
// Release all reserved video memory so graphics device may be reset.
//=============================================================================
void DashboardDemo::releaseAll()
{
    dashboardTextures.onLostDevice();

    Game::releaseAll();
    return;
}

//=============================================================================
// The grahics device has been reset.
// Recreate all surfaces and reset all entities.
//=============================================================================
void DashboardDemo::resetAll()
{
    dashboardTextures.onResetDevice();

    Game::resetAll();
    return;
}
