def get_user(id_or_name)
	fail("Missing username or userid")  if id_or_name.blank?

	if id_or_name =~ /^\d+$/
		id = id_or_name.to_i
		r = User.find_by(id:id)
	else
		name = id_or_name.upcase
		r = User.find_by(name:name)
	end
	fail("User #{id_or_name} not found")  if r.nil?

	return r
end

namespace :yomeya do
  desc "ユーザの一覧"
  task :user
  task user: :environment do |task, args|
	r = []
	User.all.order(:name).each do |x|
		r << {
		#	id: x.id,
			name: x.name,
			last_path: x.last_path,
			last_location: x.last_location,
			auth_at: x.auth_at,
		}
	end

	print JSON.pretty_generate(r)
	print "\n"
  end

  desc "ユーザを追加"
  task :user_add, "username", "password"
  task user_add: :environment do |task, args|
	username = args[:username]
	password = args[:password]
	User.add(username, password)
  end

  desc "パスワードを変更"
  task :user_password, "username", "newpass"
  task user_password: :environment do |task, args|
	user = get_user(args[:username])
	newpass = args[:newpass]
	fail("Password cannot be empty")  if newpass.blank?
	user.chpw!(newpass)
  end

  desc "ログイン可能に設定"
  task :user_enable, "username"
  task user_enable: :environment do |task, args|
	user = get_user(args[:username])
	user.enable!
  end

  desc "ログイン不可に設定"
  task :user_disable, "username"
  task user_disable: :environment do |task, args|
	user = get_user(args[:username])
	user.disable!
  end

  desc "ユーザのルートパスの一覧"
  task :root, "username"
  task root: :environment do |task, args|
	user = get_user(args[:username])

	r = []
	Root.where(user_id:user.id).order(:virt_path).each do |x|
		r << {
		#	user_name: user.name,
			virt_path: x.virt_path,
			real_path: x.real_path,
		}
	end

	print JSON.pretty_generate(r)
	print "\n"
  end

  desc "ユーザのルートパスを追加"
  task :root_add, "username", "label", "real_path"
  task root_add: :environment do |task, args|
	user = get_user(args[:username])
	label = args[:label]
	real_path = args[:real_path]

	Root.create!(user_id:user.id, virt_path:label, real_path:real_path)
  end

  desc "ユーザのルートパスを削除"
  task :root_del, "username", "label"
  task root_del: :environment do |task, args|
	user = get_user(args[:username])
	label = args[:label]

	Root.destroy_all(user_id:user.id, virt_path:label)
  end

  desc "ログを表示"
  task :log, "username"
  task log: :environment do |task, args|
	user = get_user(args[:username])

	r = []
	Log.where(user_id:user.id).order("created_at desc").limit(1000).each do |x|
		r << {
			time: x.created_at,
			event: x.event,
		}
	end
	r.sort_by! { |ev| ev[:time] }

	if true
		r.each do |ev|
			print("#{ev[:time].localtime.iso8601} : #{ev[:event]}\n")
		end
	else
		print JSON.pretty_generate(r)
		print "\n"
	end
  end

#  desc "本の一覧を出力"
#  task :books, "username"
#  task books: :environment do |task, args|
#p "未完成"
#  end

  desc "読みかけの本の一覧を出力"
  task :reading, "username"
  task reading: :environment do |task, args|
	user = get_user(args[:username])

	r = []
	Reading.where(user_id:user.id).where("start_at is not null and end_at is null").order(:path).find_each do |x|
		r << {
			path: x.path,
			location: x.location,
			start_at: x.start_at,
		#	end_at: x.end_at,
		}
	end

	print JSON.pretty_generate(r)
	print "\n"
  end

end
