class CreateTags < ActiveRecord::Migration
  def change
    create_table :tags do |t|
      t.references :user, null:false
      t.references :tag
      t.integer :order, null:false
      t.string :name, null:false

      t.timestamps

      t.index [:user_id, :tag_id, :name], unique:true
      t.index [:user_id, :tag_id, :order]
      t.index [:user_id, :name]
    end
  end
end
