class Vpath

 private
	# パス名を正規化する(virt_path用) ※文字列操作のみで実在確認はしない
	def self.reg_vpath(*path)
		path = File.join(*path)
		path.gsub!(/\.\.[\/\\]/, "")
		return File.absolute_path(path, "/").from(3)  if os_is_windows?
		return File.absolute_path(path, "/").from(1)
	end

	# パス名を正規化する(real_path用) ※文字列操作のみで実在確認はしない
	def self.reg_rpath(*path)
		path = File.join(*path)
		return File.absolute_path(path, "C:/")  if os_is_windows?
		return File.absolute_path(path, "/")
	end

	# locationを正規化する
	def self.reg_location(location)
		location = location.gsub(/\.\.[\/\\]/, "").strip
		return location
	end

	# 仮想パスを実際のパスに変換する
	def self.vpath2rpath(u, v)
		first, rest = v.split("/", 2)
		rest ||= ""
		root = Root.find_by(user_id:u, virt_path:first)
		return nil  if root.nil? # 見つからない場合は何かがおかしいのでnilを返してエラーとする
		return reg_rpath(root.real_path, rest)
	end

#	# 実際のパスを仮想パスに変換する
#	def self.rpath2vpath(u, rpath)
#		roots.each do |root_vpath, root_rpath|
#			if root_rpath == rpath || rpath.start_with?(root_rpath + "/")
#				return Vpath.reg_vpath(root_vpath, rpath.from(root_rpath.length))
#			end
#		end
#		return "" # 見つからない場合は仮想の世界に現実の世界の情報は返さない
#	end

 protected
	def r=(rpath)
		@r = rpath
	end

 public
	def initialize(user_id, *vpaths)
		fail("invalid user_id")  unless user_id.is_a?(Integer) # for safe

		@u = user_id
		@v = self.class.reg_vpath(*vpaths)
		@r = :unref
	end

	attr_reader :u, :v

	def r
		@r = self.class.vpath2rpath(@u, @v)  if @r == :unref
		return @r
	end

	def basename(ext="")
		return File.basename(@v, ext)
	end

	def root?
		return @v.blank?
	end

	def +(child)
		r = Vpath(@u, @v, child)
		if @r != :unref && r.v.start_with?(@v)
			r.r = @r + r.v.from(@v.length)
		end
		return r
	end

	def parent
		return Vpath(@u, @v, "..")
	end

end
