module ApplicationHelper

 private
	def yomeya_escape(vpath)
		return vpath.gsub(/([!"#$%&'?^|`\[\]{}+])/) do |m|
			"%%%02x" % m.ord
		end
	end

 public
	def to_path2(vpath="", location:nil)
		vpath = vpath.v  if vpath.is_a?(Vpath)
		vpath = vpath.from(1)  if vpath.start_with?("/")
		if location.present?
			return to_path(path:vpath, location:location) # yomeya_escapeは不要
		else
			return to_path(path:vpath) # yomeya_escapeは不要
		end
	end

	def filelist_path2(vpath="", location:nil)
		vpath = vpath.v  if vpath.is_a?(Vpath)
		vpath = vpath.from(1)  if vpath.start_with?("/")
		if location.present?
			return filelist_path(path:yomeya_escape(vpath), location:location)
		else
			return filelist_path(path:yomeya_escape(vpath))
		end
	end

	def viewer_path2(vpath, location:nil)
		vpath = vpath.v  if vpath.is_a?(Vpath)
		vpath = vpath.from(1)  if vpath.start_with?("/")
		if location.present?
			return viewer_path(path:yomeya_escape(vpath), location:location)
		else
			return viewer_path(path:yomeya_escape(vpath))
		end
	end

	def icon_path2(vpath, location:nil)
		vpath = vpath.v  if vpath.is_a?(Vpath)
		vpath = vpath.from(1)  if vpath.start_with?("/")
		if location.present?
			return icon_path(path:yomeya_escape(vpath), location:location)
		else
			return icon_path(path:yomeya_escape(vpath))
		end
	end

	def page_path2(vpath, location:nil)
		vpath = vpath.v  if vpath.is_a?(Vpath)
		vpath = vpath.from(1)  if vpath.start_with?("/")
		if location.present?
			return page_path(path:yomeya_escape(vpath), location:location)
		else
			return page_path(path:yomeya_escape(vpath))
		end
	end

end
