class IconController < ApplicationController

 public
	ICON_W = 48 * 2
	ICON_H = 64 * 2

 private
	# 画像データをサイズ調整して返す
	def treat_blob(data)
		return nil  if data.blank?

		w, h = ICON_W, ICON_H
		imagelist = Magick::ImageList.new.from_blob(data) do
			self["jpeg", "size"] = "#{w}x#{h}"
		end
		org_format = imagelist.format
		img = imagelist.first
		ww, hh = img.columns, img.rows

#		# 背景を白に
#		bg = Magick::Image.new(ww, hh) do
#			self.background_color = "white"
#		end
#		img.composite!(bg, 0, 0, Magick::DstOverCompositeOp)

		# 拡大縮小率の設定
		ratio = 1
		if Rational(ww, hh) > Rational(w, h)
			ratio = Rational(w, ww)  if ww > w
		else
			ratio = Rational(h, hh)  if hh > h
		end

		# 拡縮実行
		r = img.thumbnail!(ratio).to_blob do
			if org_format == "JPEG"
				self.format = "JPEG"
				self.quality = 96
			else
				self.format = "PNG"
			end
		end
		return r.present? ? r : nil
	end

	# アイコンを得る ディレクトリ用(再帰)
	def get_icon_dir(vpath)
		dirs, books = [], []
		Directory(vpath).list.each do |child|
			case child[:type]
			 when :dir
				dirs << child
			 when :images, :pdf, :zip
				books << child
			end
		end

		if !books.empty?
			books.sort_by! { |v| key4sort(v[:vpath].v) }
			return get_icon(books.first[:vpath])
		elsif !dirs.empty?
			dirs.sort_by! { |v| key4sort(v[:vpath].v) }
			dirs.each do |dir|
				r = get_icon_dir(dir[:vpath])
				return r  if r.present?
			end
		end

		return nil
	end

	# アイコンを得る キャッシュなし
	def _get_icon(vpath, location)
		if File.directory?(vpath.r)
			r = get_icon_dir(vpath)
			return r  if r.present?
			return treat_blob(asset_image_data("icon_dir.png"))
		else
			r = treat_blob(Book(vpath).extract_thumbnail(ICON_W, ICON_H, location))
			return r  if r.present?
			return treat_blob(asset_image_data("icon_file_missing.png"))
		end
	end

	# アイコンを得る キャッシュあり
	def get_icon(vpath, location="")
		Cache.transaction do
			return Cache.fetch_icon(vpath, location) do
				_get_icon(vpath, location)
			end
		end
	end

 public
	def get
		vpath = Vpath(session[:user_id], params[:path] || "")
		location = Vpath.reg_location(params[:location] || "")

		# パラメータの検査
		if !valid_vpath?(vpath)
			return render(nothing:true, status:400)
		end

		# 特殊フォルダの個別アイコン
		case vpath.v
		 when "*read"
			return redirect_to(view_context.image_path("icon_book.png"))
		 when "*bookmark"
			return redirect_to(view_context.image_path("icon_bookmark.png"))
		 when "*tag"
			return redirect_to(view_context.image_path("icon_tag.png"))
		end

		# その他の通常のアイコン
		r = get_icon(vpath, location)
		if r.blank?
			return redirect_to(view_context.image_path("icon_file_missing.png"))
		end

		return send_data(r, type:"image", disposition:"inline")
	end

end
