//
//  XspfQTValueTransformers.m
//  XspfQT
//
//  Created by Hori,Masaki on 08/08/31.
//  Copyright 2008 masakih. All rights reserved.
//

#import <QTKit/QTKit.h>

#import "XspfQTValueTransformers.h"


@implementation XspfQTTimeTransformer
+ (Class)transformedValueClass
{
	return [NSNumber class];
}
+ (BOOL)allowsReverseTransformation
{
	return YES;
}
- (id)transformedValue:(id)value
{
	if(!value) return nil;
	
	QTTime t = [value QTTimeValue];
	NSTimeInterval res;
	
	if(!QTGetTimeInterval(t, &res)) {return nil;}
	
	return [NSNumber numberWithDouble:res];
}
- (id)reverseTransformedValue:(id)value
{
	if(!value) return nil;
	
	QTTime t = QTMakeTimeWithTimeInterval([value doubleValue]);
	
	return [NSValue valueWithQTTime:t];
}
@end

@implementation XspfQTTimeDateTransformer
+ (Class)transformedValueClass
{
	return [NSDate class];
}
+ (BOOL)allowsReverseTransformation
{
	return NO;
}
- (id)transformedValue:(id)value
{
	if(!value) return nil;
	
	QTTime t = [value QTTimeValue];
	NSTimeInterval res;
	
	if(!QTGetTimeInterval(t, &res)) {return nil;}
	
	res -= [[NSTimeZone systemTimeZone] secondsFromGMT];
	
	return [NSDate dateWithTimeIntervalSince1970:res];
}
@end


@implementation XspfQTSizeToStringTransformer
+ (Class)transformedValueClass
{
	return [NSString class];
}
+ (BOOL)allowsReverseTransformation
{
	return NO;
}
- (id)transformedValue:(id)value
{
	if(!value) return nil;
	
	NSSize size = [value sizeValue];
	
	return [NSString stringWithFormat:@"%.0f X %.0f", size.width, size.height];
}
@end

@implementation XspfQTFileSizeStringTransformer
+ (Class)transformedValueClass
{
	return [NSString class];
}
+ (BOOL)allowsReverseTransformation
{
	return NO;
}
- (id)transformedValue:(id)value
{
	if(!value) return nil;
	
	double dSize = [value longLongValue];
	
	if(dSize < 1024) {
		return [NSString stringWithFormat:@"%.0f Byte", dSize];
	}
	
	dSize /= 1024;
	if(dSize < 1024) {
		return [NSString stringWithFormat:@"%.2f KB", dSize];
	}
	
	dSize /= 1024;
	if(dSize < 1024) {
		return [NSString stringWithFormat:@"%.2f MB", dSize];
	}
	
	dSize /= 1024;
	return [NSString stringWithFormat:@"%.2f GB", dSize];
}
@end

