//
//  XspfQTMovieViewController.m
//  XspfQT
//
//  Created by Hori,Masaki on 2013/06/18.
//  Copyright (c) 2013年 masakih. All rights reserved.
//

#import "XspfQTMovieViewController.h"
#import "XspfQTDocument.h"
#import "HMXSPFComponent.h"


@interface XspfQTMovieViewController ()

@end

static const float sVolumeDelta = 0.1;
//static const NSTimeInterval sUpdateTimeInterval = 0.5;
//static NSString *const kQTMovieKeyPath = @"playingMovie";
//static NSString *const kIsPlayedKeyPath = @"trackList.isPlayed";
static NSString *const kVolumeKeyPath = @"qtMovie.volume";


@implementation XspfQTMovieViewController

- (id)init
{
	self = [super initWithNibName:@"XspfQTMovieViewController" bundle:nil];
	
	return self;
}

- (void)dealloc
{
	[self pause:nil];
	[super dealloc];
}


- (QTMovieView *)movieView
{
	return (QTMovieView *)[self view];
}

- (void)setQtDocument:(XspfQTDocument *)document
{
	[self setRepresentedObject:document];
}
- (XspfQTDocument *)qtDocument
{
	return (XspfQTDocument *)[self representedObject];
}

- (QTMovie *)qtMovie
{
	return [self.movieView movie];
}

- (void)play
{
	[self performSelectorOnMainThread:@selector(play:) withObject:self waitUntilDone:NO];
}
- (void)pause
{
	[self performSelectorOnMainThread:@selector(pause:) withObject:self waitUntilDone:NO];
}
- (void)stop
{
	[self performSelectorOnMainThread:@selector(pause:) withObject:self waitUntilDone:YES];
}

- (IBAction)togglePlayAndPause:(id)sender
{
	if([[self valueForKeyPath:@"qtDocument.trackList.isPlayed"] boolValue]) {
		[self pause];
	} else {
		[self play];
	}
}
- (IBAction)play:(id)sender
{
	[self.movieView play:sender];
}
- (IBAction)pause:(id)sender
{
	[self.movieView pause:sender];
}
- (IBAction)gotoBeginning:(id)sender
{
	[self.movieView gotoBeginning:sender];
}
- (IBAction)gotoEnd:(id)sender
{
	[self.movieView gotoEnd:sender];
}
- (IBAction)nextTrack:(id)sender
{
	[self pause:sender];
	[self.qtDocument.trackList next];
}
- (IBAction)previousTrack:(id)sender
{
	[self pause:sender];
	[self.qtDocument.trackList previous];
}
- (IBAction)gotoBeginningOrPreviousTrack:(id)sender
{
	QTTime current = [self.qtMovie currentTime];
	NSTimeInterval cur;
	if(!QTGetTimeInterval(current, &cur)) return;
	
	QTTime duration = [self.qtMovie duration];
	NSTimeInterval dur;
	if(!QTGetTimeInterval(duration, &dur)) return;
	
	if(cur > (dur * 0.01)) {
		[self gotoBeginning:sender];
	} else {
		[self previousTrack:sender];
	}
}

- (IBAction)gotoThumbnailFrame:(id)sender
{
	HMXSPFComponent *trackList = self.qtDocument.trackList;
	HMXSPFComponent *thumbnailTrack = trackList.thumbnailTrack;
	NSTimeInterval time = trackList.thumbnailTimeInterval;
	
	NSUInteger num = [trackList indexOfChild:thumbnailTrack];
	if(num == NSNotFound) return;
	
	trackList.selectionIndex = num;
	
	QTTime new = QTMakeTimeWithTimeInterval(time);
	[self.qtMovie setCurrentTime:new];
}


- (IBAction)turnUpVolume:(id)sender
{
	NSNumber *cv = [self valueForKeyPath:kVolumeKeyPath];
	cv = [NSNumber numberWithFloat:[cv floatValue] + sVolumeDelta];
	[self setValue:cv forKeyPath:kVolumeKeyPath];
}
- (IBAction)turnDownVolume:(id)sender
{
	NSNumber *cv = [self valueForKeyPath:kVolumeKeyPath];
	cv = [NSNumber numberWithFloat:[cv floatValue] - sVolumeDelta];
	[self setValue:cv forKeyPath:kVolumeKeyPath];
}

- (IBAction)forwardTagValueSecends:(id)sender
{
	if(![sender respondsToSelector:@selector(tag)]) return;
	
	int tag = [sender tag];
	if(tag == 0) return;
	
	QTTime current = [self.qtMovie currentTime];
	NSTimeInterval cur;
	if(!QTGetTimeInterval(current, &cur)) return;
	
	QTTime new = QTMakeTimeWithTimeInterval(cur + tag);
	[self.qtMovie setCurrentTime:new];
}
- (IBAction)backwardTagValueSecends:(id)sender
{
	if(![sender respondsToSelector:@selector(tag)]) return;
	
	int tag = [sender tag];
	if(tag == 0) return;
	
	QTTime current = [self.qtMovie currentTime];
	NSTimeInterval cur;
	if(!QTGetTimeInterval(current, &cur)) return;
	
	QTTime new = QTMakeTimeWithTimeInterval(cur - tag);
	[self.qtMovie setCurrentTime:new];
}

#pragma mark ### NSMenu valivation ###
- (BOOL)validateMenuItem:(NSMenuItem *)menuItem
{
	SEL action = [menuItem action];
	
	if(action == @selector(gotoThumbnailFrame:)) {
		if(!self.qtDocument.trackList.thumbnailTrack) return NO;
	}
	
	return YES;
}

@end
