package hiro.yoshioka.util;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

import org.eclipse.swt.program.Program;

public class ProgramUtil {
	private static final List<String> httpProgramNameList = new ArrayList<String>();
	private static final List<String> excelNameList = new ArrayList<String>();
	private static final String[] HTML_EXTENTIONS = { "htm", "html" };
	private static final String[] EXCEL_EXTENTIONS = { "xls", "cal" };
	static {
		httpProgramNameList.add("Firefox");
		httpProgramNameList.add("Google Chrome");
		httpProgramNameList.add("Safari");

		excelNameList.add("Microsoft Excel");
		excelNameList.add("OpenDocument スプレッドシート");
		excelNameList.add("OpenOffice.org 1.1 スプレッドシート");
	}

	public static void main(String[] args) {
		System.out.println(getHtmlPrograms());
		System.out.println(getNotesProgram());
		System.out.println(getExcelPrograms());
	}

	public static Program getNotesProgram() {
		return Program.findProgram("nsf");
	}

	public static Set<Program> getExcelPrograms() {
		Set<Program> retSet = new LinkedHashSet<Program>();
		for (String extention : EXCEL_EXTENTIONS) {
			Program program_ext = Program.findProgram(extention);
			if (program_ext != null) {
				retSet.add(program_ext);
			}
		}
		for (Program program : Program.getPrograms()) {
			if (excelNameList.contains(program.getName())) {
				retSet.add(program);
			}
		}
		return retSet;
	}

	public static Set<Program> getHtmlPrograms() {
		Set<Program> retSet = new LinkedHashSet<Program>();
		for (String extention : HTML_EXTENTIONS) {
			Program program_ext = Program.findProgram(extention);
			if (program_ext != null) {
				retSet.add(program_ext);
			}
		}
		for (Program program : Program.getPrograms()) {
			if (httpProgramNameList.contains(program.getName())) {
				retSet.add(program);
			}
		}
		return retSet;
	}
}
