package hiro.yoshioka.util;

import org.eclipse.jface.resource.FontRegistry;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;

public class FontUtil {
	static FontRegistry registry;

	public synchronized static Font getFont(FontNameEnum fne) {
		return getRegistry().get(fne.name());
	}

	public synchronized static boolean chageFontSize(Composite targetComposite,
			int changeToSize) {
		if (targetComposite == null || changeToSize < 6) {
			return false;
		}
		FontData[] fD = targetComposite.getFont().getFontData();
		if (fD == null || fD.length < 1) {
			return false;
		}
		String keyName = fD[0].name + "-" + fD[0].style + "-" + changeToSize;
		Font newFont = registry.get(keyName);
		if (newFont == null) {
			fD[0].setHeight(changeToSize);
			registry.put(keyName, fD);
		}
		targetComposite.setFont(newFont);
		return true;
	}

	public synchronized static final FontRegistry getRegistry() {
		if (registry == null) {
			registry = new FontRegistry();

			Display device = Display.getCurrent();
			for (FontNameEnum fne : FontNameEnum.values()) {
				Font f = fne.getFont(device);
				registry.put(fne.name(), f.getFontData());
			}
		}
		return registry;
	}
}
