package hiro.yoshioka.util.logging;

import java.util.logging.Level;
import java.util.logging.LogRecord;

import org.eclipse.swt.widgets.Display;

public class JDK14MyLoggingHandler extends AbsMyLoggingHandler {
	private static java.util.logging.Logger jdk14Logger;
	private InnerLoggingHandler handler = new InnerLoggingHandler();

	public JDK14MyLoggingHandler() {
		jdk14Logger = java.util.logging.Logger.global.getParent();
		jdk14Logger.addHandler(handler);
	}

	@Override
	public void setLevel(String level) {
		jdk14Logger.setLevel(java.util.logging.Level.parse(level));
	}

	@Override
	public String getLevel() {
		return jdk14Logger.getLevel().getName();
	}

	class InnerLoggingHandler extends java.util.logging.Handler {
		public synchronized void publish(LogRecord record) {
			if (!isLoggable(record)) {
				return;
			}
			consoleWrite(record.getLevel(), new LLLFormatter().format(record));

		}

		protected void consoleWrite(Level level, String string) {
			if (styledText == null) {
				return;
			}
			if (!styledText.isDisposed()) {
				StyledTextData data = new StyledTextData(styledText,
						fColorMap.get(level.getName() + "_F"),
						fColorMap.get(level.getName() + "_B"), string);
				Display display = styledText.getDisplay();
				if (display.getThread() == Thread.currentThread()) {
					JDK14MyLoggingHandler.this.consoleWrite(data);
				} else {
					display.asyncExec(new StyledTextRunnable(data));
				}
			}
		}

		public void close() throws SecurityException {
			System.out.println("close called..");
		}

		public void flush() {
			System.out.println("flush called..");
		}
	}

}