package hiro.yoshioka.chart;

import hiro.yoshioka.sdh.ResultSetDataHolder;

public class PieChartInfo extends ChartInfo {

	/**
	 * PieChartInfo
	 * 
	 * @param params
	 *            [] {ChartTitle,valueIndex,topCout}
	 */
	public PieChartInfo(String[] params) {
		super(params[0], null);
		this.titleIndex = parseInt(params[1]);
		this.valueIndex = parseInt(params[2]);
		if (params.length > 3) {
			this.topCout = parseInt(params[3]);
		}
	}

	/**
	 * PieChartInfo
	 * 
	 * @param title
	 *            ChartTitle
	 * @param rdh
	 *            ResultSetDataHolder
	 * @param titleIndex
	 *            titleIndex
	 * @param valueIndex
	 *            valueIndex
	 * @param topCout
	 *            topCout
	 */
	public PieChartInfo(String title, ResultSetDataHolder rdh, int titleIndex,
			int valueIndex, int topCout) {
		super(title, rdh);
		this.titleIndex = titleIndex;
		this.valueIndex = valueIndex;
		this.topCout = topCout;
	}

	public int titleIndex;
	public int valueIndex;
	public int topCout;

	@Override
	public String toString() {
		return getClass().getName() + "y" + super.toString() + " titleIndex:"
				+ titleIndex + " valueIndex:" + valueIndex + "z";
	}
}
