package hiro.yoshioka.sdh;

import hiro.yoshioka.util.StringUtil;

public enum DatabaseType {
	// -------------------------------------------------------------------------
	// NO SQL
	// -------------------------------------------------------------------------
	EVERNOTE("evernote", "evernote"), MONGO(".*mongodb.Mongo",
			"com.mongodb.Mongo"),
	// -------------------------------------------------------------------------
	// LOTSU NOTES DOMINO SERVER
	// -------------------------------------------------------------------------
	DOMINO("lotus.domino.database", "lotus.domino.database"),
	// -------------------------------------------------------------------------
	// TWITTER
	// -------------------------------------------------------------------------
	TWITTER("twitter4j.Twitter", "twitter4j.Twitter"),
	// -------------------------------------------------------------------------
	// SQL
	// -------------------------------------------------------------------------
	/** oracle */
	ORACLE(".*oracle.*", StringUtil.EMPTY_STRING),
	/** my sql */
	MYSQL(".*mysql.*", StringUtil.EMPTY_STRING),
	/** hyper sonic sql */
	HSQL("org.hsqldb.*", "org.hsqldb.jdbcDriver"),
	/** microsoft sql server */
	MS_SQLSERVER(".*sqlserver.*", StringUtil.EMPTY_STRING),
	/** fujitsu sybase */
	SYBASE(".*sybase.*", StringUtil.EMPTY_STRING),
	/** postgres */
	POSTGRES(".*postgresql.*", StringUtil.EMPTY_STRING),
	/** sqlite */
	SQLITE(".*sqlite.*", StringUtil.EMPTY_STRING),
	/** odbc */
	ODBC(".*odbc.*", "sun.jdbc.odbc.JdbcOdbcDriver"),
	/** unkown */
	UNKNOWN("unkown", StringUtil.EMPTY_STRING);

	private String driverPattern;
	private String driverName;

	private DatabaseType(String driverPattern, String driverName) {
		this.driverPattern = driverPattern;
		this.driverName = driverName;
	}

	public static DatabaseType parse(String driver) {
		for (DatabaseType types : values()) {
			if (driver.matches(types.driverPattern)) {
				return types;
			}
		}
		System.out.println("DatabaseType#parse retunKnown");
		return UNKNOWN;
	}

	public boolean forceAutoCommitTrue() {
		switch (this) {
		case SQLITE:
		case MS_SQLSERVER:
			return true;
		}
		return false;
	}

	public String getDriverName() {
		return driverName;
	}

	public String getDriverPattern() {
		return driverPattern;
	}

	public boolean isMongo() {
		return MONGO.equals(this);
	}

	public boolean isDomino() {
		return DOMINO.equals(this);
	}

	public boolean isTwitter() {
		return TWITTER.equals(this);
	}

	public boolean isOracle() {
		return ORACLE.equals(this);
	}

	public boolean isSQLServer() {
		return MS_SQLSERVER.equals(this);
	}

	public boolean isSQLite() {
		return SQLITE.equals(this);
	}

	public boolean isHsql() {
		return HSQL.equals(this);
	}

	public boolean isPostgres() {
		return POSTGRES.equals(this);
	}

	public boolean isEvernote() {
		return EVERNOTE.equals(this);
	}

	public boolean isMySQL() {
		return MYSQL.equals(this);
	}

	public boolean needsDatabaseDefine() {
		switch (this) {
		case MONGO:
			return true;
		}
		return false;
	}

	public boolean enableRecursiveSearch() {
		switch (this) {
		case MONGO:
		case DOMINO:
			return true;
		}
		return false;
	}

	public boolean enableCategoryFilter() {
		switch (this) {
		case DOMINO:
		case ORACLE:
			return true;
		}
		return false;
	}

	public boolean enableFilePathFilter() {
		switch (this) {
		case DOMINO:
			return true;
		}
		return false;
	}

	public boolean supportVarchar2() {
		switch (this) {
		case ORACLE:
			return true;
		}
		return false;
	}

}
