package hiro.yoshioka.util.ui;

import hiro.yoshioka.util.StringUtil;

import java.util.ArrayList;

import org.eclipse.jface.contentassist.IContentAssistSubjectControl;
import org.eclipse.jface.contentassist.ISubjectControlContentAssistProcessor;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.CompletionProposal;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;

public class MySubjectControlContentAssistProcessor implements
		ISubjectControlContentAssistProcessor {
	String[] fCompletionStrings = new String[0];

	public MySubjectControlContentAssistProcessor() {
		// TODO Auto-generated constructor stub
	}

	public MySubjectControlContentAssistProcessor(String[] strings) {
		fCompletionStrings = strings;
	}

	public ICompletionProposal[] computeCompletionProposals(
			IContentAssistSubjectControl contentAssistSubjectControl,
			int documentOffset) {

		String qualifier = getQualifier(
				contentAssistSubjectControl.getDocument(), documentOffset);

		ArrayList<CompletionProposal> list = new ArrayList<CompletionProposal>();
		System.out.println();
		System.out.println();
		System.out.println();
		System.out.println("quali=" + qualifier);
		for (int i = 0; i < fCompletionStrings.length; i++) {
			if (fCompletionStrings[i].toUpperCase().startsWith(
					qualifier.toUpperCase())) {
				int spos = documentOffset - qualifier.length();

				System.out.println("fCompletionStrings[i]="
						+ fCompletionStrings[i]);
				System.out.println("spos=" + spos);
				System.out.println("qualifier.length()=" + qualifier.length());

				CompletionProposal cp = new CompletionProposal(
						fCompletionStrings[i], spos, qualifier.length(), spos
								+ fCompletionStrings[i].length());
				list.add(cp);
			}
		}

		return list.toArray(new CompletionProposal[list.size()]);
	}

	private String getQualifier(IDocument doc, int documentOffset) {
		if (documentOffset <= 0) {
			return StringUtil.EMPTY_STRING;
		}

		StringBuffer buf = new StringBuffer();
		while (true) {
			try {

				// Read character backwards
				char c = doc.getChar(--documentOffset);

				buf.append(c);
				if (documentOffset == 0 || Character.isWhitespace(c)
						|| c == '=' || c == ',') {
					return buf.reverse().toString().trim();
				}

			} catch (Exception e) {
				return StringUtil.EMPTY_STRING;
			}
		}
	}

	public IContextInformation[] computeContextInformation(
			IContentAssistSubjectControl contentAssistSubjectControl,
			int documentOffset) {

		// TODO Auto-generated method stub
		return null;
	}

	public ICompletionProposal[] computeCompletionProposals(ITextViewer viewer,
			int offset) {
		return null;
	}

	public IContextInformation[] computeContextInformation(ITextViewer viewer,
			int offset) {
		// TODO Auto-generated method stub
		return null;
	}

	public char[] getCompletionProposalAutoActivationCharacters() {
		// TODO Auto-generated method stub
		return null;
	}

	public char[] getContextInformationAutoActivationCharacters() {
		// TODO Auto-generated method stub
		return null;
	}

	public IContextInformationValidator getContextInformationValidator() {
		// TODO Auto-generated method stub
		return null;
	}

	public String getErrorMessage() {
		// TODO Auto-generated method stub
		return null;
	}

}
