package hiro.yoshioka.sdh;

import hiro.yoshioka.util.StringUtil;

import java.io.Serializable;

public class StringRecordData implements Serializable, Cloneable {
	protected String fString;
	private StringRecordPairData fPairData;

	public StringRecordData(String string) {
		fString = string;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see java.lang.Object#clone()
	 */
	public Object clone() throws CloneNotSupportedException {
		StringRecordData clone = new StringRecordData(fString);
		// clone.setPair(fPairData);
		return clone;
	}

	public void setPair(StringRecordPairData pairData) {
		fPairData = pairData;
		pairData.fParent = this;
	}

	public static StringRecordData[] createStringRecordData(String[] target) {
		StringRecordData[] ret = new StringRecordData[target.length];
		for (int i = 0; i < target.length; i++) {
			ret[i] = new StringRecordData(target[i]);
		}
		return ret;
	}

	/**
	 * If not a number , return -1;
	 * 
	 * @return
	 */
	public int getInt() {
		return StringUtil.parseIntNoneException(fString, -1);
	}

	public String getString() {
		return fString == null ? StringUtil.EMPTY_STRING : fString;
	}

	/**
	 * @return
	 */
	public StringRecordPairData getPair() {
		return fPairData;
	}

	public String toString() {
		return fString + " Pair[" + fPairData + "]";
	}

	/**
	 * @param text
	 */
	public void setString(String text) {
		fString = text;
	}
}