package hiro.yoshioka.ui.multispan;

import hiro.yoshioka.sdh.CSVRecordDataHolder;
import hiro.yoshioka.sdh.StringRecordData;
import hiro.yoshioka.sdh.pair.DifferenceStringData;
import hiro.yoshioka.sdh.pair.FlashStringData;
import hiro.yoshioka.util.Differencer;

import java.awt.Color;
import java.awt.Component;

import javax.swing.BorderFactory;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;

public class RowTableCellRenderer extends DefaultTableCellRenderer {
	private static final Color ec = Color.YELLOW;

	private Color rowColor = ec;

	private Color nullColor = Color.GREEN;

	public RowTableCellRenderer() {
		super();
		setOpaque(true);
		setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5));
	}

	public Component getTableCellRendererComponent(JTable table, Object value,
			boolean isSelected, boolean hasFocus, int row, int column) {
		super.getTableCellRendererComponent(table, value, isSelected, hasFocus,
				row, column);
		if (value == null || value.toString().length() == 0) {
			setBackground(nullColor);
			return this;
		}

		if (isSelected) {
			setForeground(table.getSelectionForeground());
			setBackground(table.getSelectionBackground());
		} else {
			setForeground(table.getForeground());
			setBackground((row % 2 == 1) ? rowColor : table.getBackground());
		}

		boolean supportDiff = ((SimaTable) table).supportDiff();
		CSVRecordDataHolder rdh = ((ResultSetTableModel) table.getModel()).rdh;
		StringRecordData[] datum = rdh.getStringRecordRow(row);
		if (supportDiff
				&& datum[column].getPair() instanceof DifferenceStringData) {
			DifferenceStringData d = (DifferenceStringData) datum[column]
					.getPair();
			switch (d.fDifferenceKind) {
			case Differencer.ADDITION:
				setBackground(Color.MAGENTA);
				break;
			case Differencer.CHANGE:
				setBackground(Color.RED);
				break;
			case Differencer.DELETION:
				setBackground(Color.LIGHT_GRAY);
				break;
			}
		}

		setHorizontalAlignment((value instanceof Number) ? RIGHT : LEFT);
		return this;
	}

	public void setNullColor(Color c) {
		if (c == null) {
			c = Color.GREEN;
		}
		nullColor = c;
	}

	public void setOddRowColor(Color c) {
		if (c == null) {
			c = ec;
		}
		rowColor = c;
	}
}
