package hiro.yoshioka.ui.multispan;

import hiro.yoshioka.sdh.IDiffSupport;
import hiro.yoshioka.sdh.ResultSetDataHolder;

import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;

import javax.swing.JTable;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class SimaTable extends JTable implements IDiffSupport {
	private RowTableCellRenderer fRowTableCellRenderer = new RowTableCellRenderer();
	ExcelAdapter adapter;

	boolean supportDiff;

	public SimaTable() {
		init();
	}

	public SimaTable(TableModel model) {
		super(model);
		init();
	}

	public void setRowColor(Color c) {
		fRowTableCellRenderer.setOddRowColor(c);
	}

	public void setNullColor(Color c) {
		fRowTableCellRenderer.setNullColor(c);
	}

	public ExcelAdapter getAdapter() {
		return adapter;
	}

	private void init() {
		addMouseListener(new MouseAdapter() {
			@Override
			public void mouseClicked(MouseEvent e) {
				if (getSelectedColumn() == 0) {
					setColumnSelectionInterval(0, getColumnCount() - 1);
				}
			}
		});
		setCellSelectionEnabled(true);
		setDefaultRenderer(Object.class, fRowTableCellRenderer);
		setColumnSelectionAllowed(true);
		setRowSelectionAllowed(true);
		setAutoResizeMode(JTable.AUTO_RESIZE_OFF);
		adapter = new ExcelAdapter(this);
	}

	public void adjustHeaderWidth() {
		TableColumnModel cm = getColumnModel();
		FontMetrics fm = getFontMetrics(getFont());

		for (int i = 1; i <= cm.getColumnCount(); i++) {
			String targetString = getModel().getColumnName(i - 1);
			int maxw = fm.charsWidth(targetString.toCharArray(), 0,
					targetString.length());
			cm.getColumn(i - 1).setPreferredWidth(maxw + 10);
		}
	}

	public void adjustDataWidth() {
		TableColumnModel cm = getColumnModel();
		FontMetrics fm = getFontMetrics(getFont());

		for (int i = 1; i <= cm.getColumnCount(); i++) {
			String targetString = getModel().getColumnName(i - 1);
			int maxw = fm.charsWidth(targetString.toCharArray(), 0,
					targetString.length());
			for (int j = 0; j < getRowCount(); j++) {
				targetString = (String) getModel().getValueAt(j, i - 1);
				int mc = fm.charsWidth(targetString.toCharArray(), 0,
						targetString.length());

				if (maxw < mc) {
					maxw = mc;
				}
			}
			cm.getColumn(i - 1).setPreferredWidth(maxw + 10);
		}
	}

	public void deleteRows(int[] dels) {
		((ResultSetTableModel) getModel()).deleteRows(dels);
		repaint();

	}

	public ResultSetDataHolder getResultSetDataHolder() {
		return ((ResultSetTableModel) getModel()).rdh;
	}

	public boolean supportDiff() {
		return supportDiff;
	}

	public void setSupportDiff(boolean supportDiff) {
		this.supportDiff = supportDiff;
	}

}
