package hiro.yoshioka.sdh;

import hiro.yoshioka.util.CSVUtil;
import hiro.yoshioka.util.ImageUtil;

import java.io.File;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class CsvViewerColumnShiftTester {

	public static void main(String[] args) {
		Display display = new Display();

		final Shell shell = new Shell(display);
		shell.setLayout(new GridLayout(2, false));

		final CDHTableViewer v = new CDHTableViewer(shell);
		v.getTable().setLayoutData(new GridData(GridData.FILL_BOTH));
		v.setInputAdjustHeader(createModel());

		final String[] columnDatum = new String[400];
		for (int i = 0; i < 400; i++) {
			columnDatum[i] = (i % 7) + "";
		}

		Composite btnPanel = new Composite(shell, SWT.BOTTOM);
		btnPanel.setLayout(new FillLayout(SWT.VERTICAL));
		Button cpBtn = new Button(btnPanel, SWT.BORDER);

		cpBtn.setText("copy");
		cpBtn.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {
				System.out
						.println("pushed cpBtn-------------------------------");
				CSVRecordDataHolder rdh = v.getCDH();
				rdh.addColumn("ima", columnDatum);
				v.setInputAdjustDatum(rdh);
			}
		});

		Button insBtn = new Button(btnPanel, SWT.BORDER);
		insBtn.setText("ins");
		insBtn.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {
				CSVRecordDataHolder rdh = v.getCDH();
				rdh.insertColumn(5, "ins", new String[] { null, "hoge", "piyo",
						"", "aaaa" });
				v.setInputAdjustDatum(rdh);
			}
		});

		Button delBtn = new Button(btnPanel, SWT.BORDER);
		delBtn.setText("del");
		delBtn.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {
				CSVRecordDataHolder rdh = v.getCDH();
				rdh.deleteColumn(2);
				v.setInputAdjustDatum(rdh);
			}
		});

		Button delSave = new Button(btnPanel, SWT.BORDER);
		delSave.setText("save");
		delSave.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {
				CSVRecordDataHolder rdh = v.getCDH();
				rdh.saveCSV(new File("hoge.csv"), "Utf-8",
						CSVUtil.QUOTE_DOUBLE_QUOTE_SEPARATE_TAB, false);
			}
		});
		Button adjustDatum = new Button(btnPanel, SWT.BORDER);
		adjustDatum.setText("adjustDatum");
		adjustDatum.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {
				CSVRecordDataHolder rdh = v.getCDH();
				v.setInputAdjustDatum(rdh);
			}
		});

		Button adjustArea = new Button(btnPanel, SWT.BORDER);
		adjustArea.setText("adjustArea");
		adjustArea.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {
				CSVRecordDataHolder rdh = v.getCDH();
				v.setInputAdjustArea(rdh);
			}
		});
		adjustDatum.setImage(ImageUtil.getImage(ImageUtil.ACTION_82_ERROR));
		adjustArea.setImage(ImageUtil.getImage(ImageUtil.ACTION_43_GO));

		System.out.println("aaaaaaaa");
		shell.open();
		System.out.println("aaaaaaaabbbbbbbbbbb");

		while (!shell.isDisposed()) {
			if (!display.readAndDispatch())
				display.sleep();
		}
		System.out.println("aaaaaaaabbbbbbbbbbbddddddddddd");

		display.dispose();
	}

	private static ResultSetDataHolder createModel() {
		ResultSetDataHolder rdh = new ResultSetDataHolder(new String[] {
				"name", "job", "email", "use(%)" });
		for (int i = 0; i < 100; i++) {
			rdh.addRow(new String[] { i + "", "",
					"B8'&\\\\jj/oris_Bokowski@ca.ibm.com", i + "" });
			rdh.addRow(new String[] { i + "", "Creasey",
					"Tod_Creasey@ca.ibm.com", i % 42 + "" });
			rdh.addRow(new String[] { i + "", "Beaton", "", i % 23 + "" });
			rdh.addRow(new String[] {
					"i     am \n a\n one\n of \n pen\n this is a pen too.",
					"Schi\r\nn\r\nsdl", "tom.schindl@bestsolution.at", "100" });
		}
		// rdh.addRow(new String[] { "Boris", "Bokowski",
		// "Boris_Bokowski@ca.ibm.com" });
		// rdh.addRow(new String[] { "Tod", "Creasey", "Tod_Creasey@ca.ibm.com"
		// });
		rdh.addNotNullIdx("job");
		System.out.println(rdh);
		return rdh;
	}
}
